/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.layer.builtin;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.GenericMapRenderer;
import com.gregtechceu.gtceu.integration.map.layer.MapRenderLayer;
import com.gregtechceu.gtceu.integration.xei.widgets.GTOreVeinWidget;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;

public class OreRenderLayer
extends MapRenderLayer {
    public OreRenderLayer(String key, GenericMapRenderer renderer) {
        super(key, renderer);
    }

    public static String getId(GeneratedVeinMetadata vein) {
        BlockPos center = vein.center();
        return "ore_veins@[" + center.m_123341_() + "," + center.m_123342_() + "," + center.m_123343_() + "]";
    }

    public static Component getName(GeneratedVeinMetadata vein) {
        if (vein == null || vein.definition() == null || ClientProxy.CLIENT_ORE_VEINS.inverse().get((Object)vein.definition()) == null) {
            return Component.m_237115_((String)"gtceu.minimap.ore_vein.depleted");
        }
        return Component.m_237115_((String)("gtceu.jei.ore_vein." + GTOreVeinWidget.getOreName(vein.definition())));
    }

    public static List<Component> getTooltip(String name, GeneratedVeinMetadata vein) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237113_((String)name));
        for (Map.Entry<Either<BlockState, Material>, Integer> filler : vein.definition().veinGenerator().getAllEntries()) {
            filler.getKey().ifLeft(state -> tooltip.add((Component)Component.m_237113_((String)ConfigHolder.INSTANCE.compat.minimap.oreNamePrefix).m_7220_((Component)state.m_60734_().m_49954_()))).ifRight(material -> tooltip.add((Component)Component.m_237113_((String)ConfigHolder.INSTANCE.compat.minimap.oreNamePrefix).m_7220_((Component)TagPrefix.ore.getLocalizedName((Material)material))));
        }
        return tooltip;
    }
}

