/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jei;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTFluids;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluid;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.jei.circuit.GTProgrammedCircuitCategory;
import com.gregtechceu.gtceu.integration.jei.multipage.MultiblockInfoCategory;
import com.gregtechceu.gtceu.integration.jei.oreprocessing.GTOreProcessingInfoCategory;
import com.gregtechceu.gtceu.integration.jei.orevein.GTBedrockFluidInfoCategory;
import com.gregtechceu.gtceu.integration.jei.orevein.GTBedrockOreInfoCategory;
import com.gregtechceu.gtceu.integration.jei.orevein.GTOreVeinInfoCategory;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeJEICategory;
import com.gregtechceu.gtceu.integration.jei.subtype.PotionFluidSubtypeInterpreter;
import com.lowdragmc.lowdraglib.LDLib;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class GTJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return GTCEu.id("jei_plugin");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registry) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        GTCEu.LOGGER.info("JEI register categories");
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockInfoCategory(jeiHelpers)});
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            registry.addRecipeCategories(new IRecipeCategory[]{new GTOreProcessingInfoCategory(jeiHelpers)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new GTOreVeinInfoCategory(jeiHelpers)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GTBedrockFluidInfoCategory(jeiHelpers)});
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            registry.addRecipeCategories(new IRecipeCategory[]{new GTBedrockOreInfoCategory(jeiHelpers)});
        }
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            if (!category.shouldRegisterDisplays()) continue;
            registry.addRecipeCategories(new IRecipeCategory[]{new GTRecipeJEICategory(jeiHelpers, category)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new GTProgrammedCircuitCategory(jeiHelpers)});
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        GTRecipeJEICategory.registerRecipeCatalysts(registration);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingInfoCategory.registerRecipeCatalysts(registration);
        }
        GTOreVeinInfoCategory.registerRecipeCatalysts(registration);
        GTBedrockFluidInfoCategory.registerRecipeCatalysts(registration);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreInfoCategory.registerRecipeCatalysts(registration);
        }
        registration.addRecipeCatalyst(GTMultiMachines.LARGE_CHEMICAL_REACTOR.asStack(), new RecipeType[]{GTRecipeJEICategory.TYPES.apply(GTRecipeTypes.CHEMICAL_RECIPES.getCategory())});
        registration.addRecipeCatalyst(IntCircuitBehaviour.stack(0), new RecipeType[]{GTProgrammedCircuitCategory.RECIPE_TYPE});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        GTCEu.LOGGER.info("JEI register");
        MultiblockInfoCategory.registerRecipes(registration);
        GTRecipeJEICategory.registerRecipes(registration);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingInfoCategory.registerRecipes(registration);
        }
        GTOreVeinInfoCategory.registerRecipes(registration);
        GTBedrockFluidInfoCategory.registerRecipes(registration);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreInfoCategory.registerRecipes(registration);
        }
        registration.addRecipes(GTProgrammedCircuitCategory.RECIPE_TYPE, List.of(new GTProgrammedCircuitCategory.GTProgrammedCircuitWrapper()));
    }

    public void registerIngredients(@NotNull IModIngredientRegistration registry) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        GTCEu.LOGGER.info("JEI register ingredients");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{GTItems.PROGRAMMED_CIRCUIT.m_5456_()});
    }

    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        PotionFluidSubtypeInterpreter interpreter = new PotionFluidSubtypeInterpreter();
        PotionFluid potionFluid = (PotionFluid)((Object)GTFluids.POTION.get());
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)potionFluid.m_5613_(), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)potionFluid.m_5615_(), (IIngredientSubtypeInterpreter)interpreter);
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        ArrayList<FluidStack> potionFluids = new ArrayList<FluidStack>(BuiltInRegistries.f_256980_.m_13562_());
        for (Potion potion : BuiltInRegistries.f_256980_) {
            FluidStack potionFluid = PotionFluid.of(1000, potion);
            potionFluids.add(potionFluid);
        }
        registration.addExtraIngredients((IIngredientType)ForgeTypes.FLUID_STACK, potionFluids);
    }
}

