/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.integration.jade.provider.BlockInfoProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class SteamBoilerBlockProvider
extends BlockInfoProvider<SteamBoilerMachine> {
    public SteamBoilerBlockProvider() {
        super(GTCEu.id("steam_boiler_info"));
    }

    @Override
    @Nullable
    protected SteamBoilerMachine getCapability(Level level, BlockPos blockPos) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof SteamBoilerMachine) {
            SteamBoilerMachine steamBoilerMachine = (SteamBoilerMachine)metaMachine;
            return steamBoilerMachine;
        }
        return null;
    }

    @Override
    protected void write(CompoundTag data, SteamBoilerMachine capability, BlockAccessor block) {
        data.m_128379_("heatingUp", capability.getRecipeLogic().isWorking());
        data.m_128379_("coolingDown", capability.getCurrentTemperature() > 0);
        data.m_128379_("producingSteam", !capability.isHasNoWater() && capability.getCurrentTemperature() >= 100);
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        boolean producing = capData.m_128471_("producingSteam");
        if (capData.m_128471_("heatingUp")) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.machine.boiler.info.heating.up", (Object[])new Object[]{producing ? Component.m_237115_((String)"gtceu.machine.boiler.info.producing.steam") : ""}));
        } else if (capData.m_128471_("coolingDown")) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.machine.boiler.info.cooling.down", (Object[])new Object[]{producing ? Component.m_237115_((String)"gtceu.machine.boiler.info.producing.steam") : ""}));
        }
    }
}

