/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.forge;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.capability.compat.EUToFEProvider;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.DrumMachineItem;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.misc.forge.FilteredFluidHandlerItemStack;
import com.gregtechceu.gtceu.api.pattern.MultiblockWorldSavedData;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.capability.LocalizedHazardSavedData;
import com.gregtechceu.gtceu.common.capability.MedicalConditionTracker;
import com.gregtechceu.gtceu.common.capability.WorldIDSaveData;
import com.gregtechceu.gtceu.common.commands.GTCommands;
import com.gregtechceu.gtceu.common.commands.HazardCommands;
import com.gregtechceu.gtceu.common.commands.MedicalConditionCommands;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.machines.GTAEMachines;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluidHelper;
import com.gregtechceu.gtceu.common.item.ToggleEnergyConsumerBehavior;
import com.gregtechceu.gtceu.common.item.armor.IJetpack;
import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.SPacketSendWorldID;
import com.gregtechceu.gtceu.common.network.packets.SPacketSyncBedrockOreVeins;
import com.gregtechceu.gtceu.common.network.packets.SPacketSyncFluidVeins;
import com.gregtechceu.gtceu.common.network.packets.SPacketSyncOreVeins;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketAddHazardZone;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketRemoveHazardZone;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketSyncLevelHazards;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.loader.BedrockFluidLoader;
import com.gregtechceu.gtceu.data.loader.BedrockOreLoader;
import com.gregtechceu.gtceu.data.loader.GTOreLoader;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.integration.map.ClientCacheManager;
import com.gregtechceu.gtceu.integration.map.WaypointManager;
import com.gregtechceu.gtceu.integration.map.cache.server.ServerCache;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="gtceu", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeCommonEventListener {
    @SubscribeEvent
    public static void registerItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        final ItemStack itemStack = (ItemStack)event.getObject();
        Item item = itemStack.m_41720_();
        if (item instanceof IComponentItem) {
            final IComponentItem componentItem = (IComponentItem)item;
            event.addCapability(GTCEu.id("capability"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return componentItem.getCapability(itemStack, cap);
                }
            });
        } else {
            item = itemStack.m_41720_();
            if (item instanceof DrumMachineItem) {
                final DrumMachineItem drumMachineItem = (DrumMachineItem)item;
                event.addCapability(GTCEu.id("fluid"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                        return drumMachineItem.getCapability(itemStack, capability);
                    }
                });
            } else if (itemStack.m_41720_() instanceof PotionItem) {
                handler = LazyOptional.of(() -> {
                    FluidHandlerItemStack.SwapEmpty fluidHandler = new FluidHandlerItemStack.SwapEmpty(itemStack, new ItemStack((ItemLike)Items.f_42590_), 250);
                    fluidHandler.fill(PotionFluidHelper.getFluidFromPotionItem(itemStack, 250), IFluidHandler.FluidAction.EXECUTE);
                    return fluidHandler;
                });
                event.addCapability(GTCEu.id("potion_item_handler"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, handler);
                    }
                });
            } else if (itemStack.m_150930_(Items.f_42590_)) {
                handler = LazyOptional.of(() -> new FilteredFluidHandlerItemStack(itemStack, 250, s -> s.getFluid().m_205067_(CustomTags.POTION_FLUIDS)){

                    protected void setFluid(FluidStack fluid) {
                        super.setFluid(fluid);
                        if (!fluid.isEmpty()) {
                            this.container = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)PotionUtils.m_43577_((CompoundTag)fluid.getTag()));
                        }
                    }
                });
                event.addCapability(GTCEu.id("bottle_item_handler"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, handler);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void registerEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player entity = (Player)object;
            final MedicalConditionTracker tracker = new MedicalConditionTracker(entity);
            event.addCapability(GTCEu.id("medical_condition_tracker"), (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){

                public CompoundTag serializeNBT() {
                    return tracker.serializeNBT();
                }

                public void deserializeNBT(CompoundTag arg) {
                    tracker.deserializeNBT(arg);
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    return GTCapability.CAPABILITY_MEDICAL_CONDITION_TRACKER.orEmpty(capability, LazyOptional.of(() -> tracker));
                }
            });
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        event.addCapability(GTCEu.id("fe_capability"), (ICapabilityProvider)new EUToFEProvider((BlockEntity)event.getObject()));
    }

    @SubscribeEvent
    public static void tickPlayerInventoryHazards(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT || event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
        if (tracker == null) {
            return;
        }
        if (!ConfigHolder.INSTANCE.gameplay.hazardsEnabled) {
            for (MedicalCondition medicalCondition : tracker.getMedicalConditions().keySet()) {
                tracker.removeMedicalCondition(medicalCondition);
            }
            return;
        }
        IItemHandler inventory = player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().orElse(null);
        if (inventory == null) {
            return;
        }
        tracker.tick();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            Material material = HazardProperty.getValidHazardMaterial(stack);
            if (material == null || !material.hasProperty(PropertyKey.HAZARD)) continue;
            HazardProperty property = material.getProperty(PropertyKey.HAZARD);
            if (property.hazardTrigger.protectionType().isProtected((LivingEntity)player)) {
                property.hazardTrigger.protectionType().damageEquipment(player, 1);
                continue;
            }
            tracker.progressRelatedCondition(material);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        IInteractedMachine machine;
        MetaMachineBlock block;
        Object object;
        BlockState blockState = event.getLevel().m_8055_(event.getPos());
        if (blockState.m_155947_() && (object = blockState.m_60734_()) instanceof MetaMachineBlock && (object = (block = (MetaMachineBlock)object).getMachine((BlockGetter)event.getLevel(), event.getPos())) instanceof IInteractedMachine && (machine = (IInteractedMachine)object).onLeftClick(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        MetaMachine machine = MetaMachine.getMachine((BlockGetter)event.getLevel(), event.getPos());
        if (machine != null && !IMachineOwner.canBreakOwnerMachine(event.getPlayer(), machine.holder)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        GTCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        MedicalConditionCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        HazardCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new GTOreLoader());
        event.addListener((PreparableReloadListener)new BedrockFluidLoader());
        event.addListener((PreparableReloadListener)new BedrockOreLoader());
    }

    @SubscribeEvent
    public static void levelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TaskHandler.onTickUpdate(serverLevel);
            if (ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
                EnvironmentalHazardSavedData.getOrCreate(serverLevel).tick();
                LocalizedHazardSavedData.getOrCreate(serverLevel).tick();
            }
        }
    }

    @SubscribeEvent
    public static void worldLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            WaypointManager.updateDimension(event.getLevel());
        } else {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                ServerCache.instance.maybeInitWorld(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void worldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            TaskHandler.onWorldUnLoad(serverLevel);
            MultiblockWorldSavedData.getOrCreate(serverLevel).releaseExecutorService();
            ServerCache.instance.invalidateWorld(serverLevel);
        } else if (event.getLevel().m_5776_()) {
            ClientCacheManager.saveCaches();
        }
    }

    @SubscribeEvent
    public static void serverStarting(ServerStartingEvent event) {
        WorldIDSaveData.init(event.getServer().m_129783_());
    }

    @SubscribeEvent
    public static void serverStopped(ServerStoppedEvent event) {
        ServerCache.instance.clear();
    }

    @SubscribeEvent
    public static void serverStopping(ServerStoppingEvent event) {
        Iterable levels = event.getServer().m_129785_();
        for (ServerLevel level : levels) {
            if (level.m_5776_()) continue;
            MultiblockWorldSavedData.getOrCreate(level).releaseExecutorService();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketSendWorldID(), serverPlayer);
            if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
                return;
            }
            ServerLevel level = serverPlayer.m_284548_();
            EnvironmentalHazardSavedData data = EnvironmentalHazardSavedData.getOrCreate(level);
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketSyncLevelHazards(data.getHazardZones()), serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            GTNetwork.NETWORK.sendToAll((IPacket)new SPacketSyncOreVeins(GTRegistries.ORE_VEINS.registry()));
            GTNetwork.NETWORK.sendToAll((IPacket)new SPacketSyncFluidVeins(GTRegistries.BEDROCK_FLUID_DEFINITIONS.registry()));
            GTNetwork.NETWORK.sendToAll((IPacket)new SPacketSyncBedrockOreVeins(GTRegistries.BEDROCK_ORE_DEFINITIONS.registry()));
        } else {
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketSyncOreVeins(GTRegistries.ORE_VEINS.registry()), player);
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketSyncFluidVeins(GTRegistries.BEDROCK_FLUID_DEFINITIONS.registry()), player);
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketSyncBedrockOreVeins(GTRegistries.BEDROCK_ORE_DEFINITIONS.registry()), player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityLivingFallEvent(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            Object object;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.f_19789_ < 3.2f) {
                return;
            }
            ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (boots.m_204117_(CustomTags.STEP_BOOTS) && (object = boots.m_41720_()) instanceof ArmorComponentItem) {
                ArmorComponentItem armor = (ArmorComponentItem)object;
                armor.getArmorLogic().damageArmor((LivingEntity)player, boots, player.m_269291_().m_268989_(), (int)(player.f_19789_ - 1.2f), EquipmentSlot.FEET);
                player.f_19789_ = 0.0f;
                event.setCanceled(true);
            } else {
                IJetpack jetpack;
                ArmorComponentItem armor;
                object = chest.m_41720_();
                if (object instanceof ArmorComponentItem && (object = (armor = (ArmorComponentItem)object).getArmorLogic()) instanceof IJetpack && (jetpack = (IJetpack)object).canUseEnergy(chest, jetpack.getEnergyPerUse()) && player.f_19789_ >= player.m_21223_() + 3.2f) {
                    IJetpack.performEHover(chest, (Player)player);
                    player.f_19789_ = 0.0f;
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void stepAssistHandler(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        float MAGIC_STEP_HEIGHT = 1.0023f;
        if (event.getEntity() == null || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.m_6047_() && player.m_6844_(EquipmentSlot.FEET).m_204117_(CustomTags.STEP_BOOTS)) {
            if (player.getStepHeight() < MAGIC_STEP_HEIGHT) {
                player.m_274367_(MAGIC_STEP_HEIGHT);
            }
        } else if (player.getStepHeight() == MAGIC_STEP_HEIGHT) {
            player.m_274367_(0.6f);
        }
    }

    @SubscribeEvent
    public static void onEntityDie(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
            if (tracker == null) {
                return;
            }
            for (MedicalCondition condition : tracker.getMedicalConditions().keySet()) {
                tracker.removeMedicalCondition(condition);
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        Difficulty difficulty = entity.m_9236_().m_46791_();
        if (difficulty == Difficulty.HARD && entity.m_217043_().m_188501_() <= 0.03f && entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            if (ConfigHolder.INSTANCE.tools.nanoSaber.zombieSpawnWithSabers) {
                ItemStack itemStack = ((ComponentItem)GTItems.NANO_SABER.get()).getInfiniteChargedStack();
                ToggleEnergyConsumerBehavior.setItemActive(itemStack, true);
                entity.m_8061_(EquipmentSlot.MAINHAND, itemStack);
                zombie.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLevelChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        ServerLevel newLevel = event.getEntity().m_20194_().m_129880_(event.getTo());
        EnvironmentalHazardSavedData data = EnvironmentalHazardSavedData.getOrCreate(newLevel);
        GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketSyncLevelHazards(data.getHazardZones()), (ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ChunkPos pos = event.getPos();
        ServerPlayer player = event.getPlayer();
        EnvironmentalHazardSavedData data = EnvironmentalHazardSavedData.getOrCreate(event.getLevel());
        EnvironmentalHazardSavedData.HazardZone zone = data.getZoneByPos(pos);
        if (zone != null) {
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketAddHazardZone(pos, zone), player);
        }
    }

    @SubscribeEvent
    public static void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
        ChunkPos pos = event.getPos();
        ServerPlayer player = event.getPlayer();
        EnvironmentalHazardSavedData data = EnvironmentalHazardSavedData.getOrCreate(event.getLevel());
        EnvironmentalHazardSavedData.HazardZone zone = data.getZoneByPos(pos);
        if (zone != null) {
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketRemoveHazardZone(pos), player);
        }
    }

    @SubscribeEvent
    public static void remapIds(MissingMappingsEvent event) {
        event.getMappings(Registries.f_256747_, "gtceu").forEach(mapping -> {
            if (mapping.getKey().equals((Object)GTCEu.id("tungstensteel_coil_block"))) {
                mapping.remap((Object)((Block)GTBlocks.COIL_RTMALLOY.get()));
            }
            if (mapping.getKey().equals((Object)GTCEu.id("steam_miner"))) {
                mapping.remap((Object)((MachineDefinition)GTMachines.STEAM_MINER.first()).getBlock());
            }
        });
        event.getMappings(Registries.f_256913_, "gtceu").forEach(mapping -> {
            if (mapping.getKey().equals((Object)GTCEu.id("tungstensteel_coil_block"))) {
                mapping.remap((Object)((CoilBlock)GTBlocks.COIL_RTMALLOY.get()).m_5456_());
            }
            if (mapping.getKey().equals((Object)GTCEu.id("steam_miner"))) {
                mapping.remap((Object)((MachineDefinition)GTMachines.STEAM_MINER.first()).getItem());
            }
        });
        event.getMappings(Registries.f_256922_, "gtceu").forEach(mapping -> {
            if (mapping.getKey().equals((Object)GTCEu.id("steam_miner"))) {
                mapping.remap(((MachineDefinition)GTMachines.STEAM_MINER.first()).getBlockEntityType());
            }
        });
        event.getMappings(Registries.f_256747_, "gregiceng").forEach(mapping -> {
            String path;
            switch (path = mapping.getKey().m_135815_()) {
                case "stocking_bus": 
                case "adv_stocking_bus": {
                    mapping.remap((Object)GTAEMachines.STOCKING_IMPORT_BUS_ME.getBlock());
                    break;
                }
                case "stocking_hatch": 
                case "adv_stocking_hatch": {
                    mapping.remap((Object)GTAEMachines.STOCKING_IMPORT_HATCH_ME.getBlock());
                    break;
                }
                case "crafting_io_buffer": {
                    mapping.remap((Object)GTAEMachines.ME_PATTERN_BUFFER.getBlock());
                    break;
                }
                case "crafting_io_slave": {
                    mapping.remap((Object)GTAEMachines.ME_PATTERN_BUFFER_PROXY.getBlock());
                }
            }
            if (path.contains("input_buffer")) {
                newName = GTCEu.id(path.replace("input_buffer", "dual_input_hatch"));
                if (mapping.getRegistry().containsKey(newName)) {
                    mapping.remap((Object)((Block)mapping.getRegistry().getValue(newName)));
                } else {
                    mapping.remap((Object)GTMachines.DUAL_IMPORT_HATCH[6].getBlock());
                }
            } else if (path.contains("output_buffer")) {
                newName = GTCEu.id(path.replace("output_buffer", "dual_output_hatch"));
                if (mapping.getRegistry().containsKey(newName)) {
                    mapping.remap((Object)((Block)mapping.getRegistry().getValue(newName)));
                } else {
                    mapping.remap((Object)GTMachines.DUAL_EXPORT_HATCH[6].getBlock());
                }
            }
        });
        event.getMappings(Registries.f_256922_, "gregiceng").forEach(mapping -> {
            String path;
            switch (path = mapping.getKey().m_135815_()) {
                case "stocking_bus": 
                case "adv_stocking_bus": {
                    mapping.remap(GTAEMachines.STOCKING_IMPORT_BUS_ME.getBlockEntityType());
                    break;
                }
                case "stocking_hatch": 
                case "adv_stocking_hatch": {
                    mapping.remap(GTAEMachines.STOCKING_IMPORT_HATCH_ME.getBlockEntityType());
                    break;
                }
                case "crafting_io_buffer": {
                    mapping.remap(GTAEMachines.ME_PATTERN_BUFFER.getBlockEntityType());
                    break;
                }
                case "crafting_io_slave": {
                    mapping.remap(GTAEMachines.ME_PATTERN_BUFFER_PROXY.getBlockEntityType());
                }
            }
            if (path.contains("input_buffer")) {
                newName = GTCEu.id(path.replace("input_buffer", "dual_input_hatch"));
                if (mapping.getRegistry().containsKey(newName)) {
                    mapping.remap((Object)((BlockEntityType)mapping.getRegistry().getValue(newName)));
                } else {
                    mapping.remap(GTMachines.DUAL_IMPORT_HATCH[6].getBlockEntityType());
                }
            } else if (path.contains("output_buffer")) {
                newName = GTCEu.id(path.replace("output_buffer", "dual_output_hatch"));
                if (mapping.getRegistry().containsKey(newName)) {
                    mapping.remap((Object)((BlockEntityType)mapping.getRegistry().getValue(newName)));
                } else {
                    mapping.remap(GTMachines.DUAL_EXPORT_HATCH[6].getBlockEntityType());
                }
            }
        });
        event.getMappings(Registries.f_256913_, "gregiceng").forEach(mapping -> {
            String path;
            switch (path = mapping.getKey().m_135815_()) {
                case "stocking_bus": 
                case "adv_stocking_bus": {
                    mapping.remap((Object)GTAEMachines.STOCKING_IMPORT_BUS_ME.getItem());
                    break;
                }
                case "stocking_hatch": 
                case "adv_stocking_hatch": {
                    mapping.remap((Object)GTAEMachines.STOCKING_IMPORT_HATCH_ME.getItem());
                    break;
                }
                case "crafting_io_buffer": {
                    mapping.remap((Object)GTAEMachines.ME_PATTERN_BUFFER.getItem());
                    break;
                }
                case "crafting_io_slave": {
                    mapping.remap((Object)GTAEMachines.ME_PATTERN_BUFFER_PROXY.getItem());
                }
            }
            if (path.contains("input_buffer")) {
                newName = GTCEu.id(path.replace("input_buffer", "dual_input_hatch"));
                if (mapping.getRegistry().containsKey(newName)) {
                    mapping.remap((Object)((Item)mapping.getRegistry().getValue(newName)));
                } else {
                    mapping.remap((Object)GTMachines.DUAL_IMPORT_HATCH[6].getItem());
                }
            } else if (path.contains("output_buffer")) {
                newName = GTCEu.id(path.replace("output_buffer", "dual_output_hatch"));
                if (mapping.getRegistry().containsKey(newName)) {
                    mapping.remap((Object)((Item)mapping.getRegistry().getValue(newName)));
                } else {
                    mapping.remap((Object)GTMachines.DUAL_EXPORT_HATCH[6].getItem());
                }
            }
        });
        for (TagPrefix prefix : TagPrefix.values()) {
            String first = prefix.invertedName ? FormattingUtil.toLowerCaseUnder(prefix.name) : "(.+?)";
            String last = prefix.invertedName ? "(.+?)" : FormattingUtil.toLowerCaseUnder(prefix.name);
            Pattern idPattern = Pattern.compile(first + "_" + last);
            event.getMappings(Registries.f_256747_, "gtceu").forEach(mapping -> {
                BlockEntry block;
                Matcher matcher = idPattern.matcher(mapping.getKey().m_135815_());
                if (matcher.matches() && (block = (BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)prefix, GTCEuAPI.materialManager.getRegistry("gtceu").get(matcher.group(1)))) != null && block.isPresent()) {
                    mapping.remap((Object)((Block)block.get()));
                }
            });
            event.getMappings(Registries.f_256913_, "gtceu").forEach(mapping -> {
                Matcher matcher = idPattern.matcher(mapping.getKey().m_135815_());
                if (matcher.matches()) {
                    BlockEntry block = (BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)prefix, GTCEuAPI.materialManager.getRegistry("gtceu").get(matcher.group(1)));
                    if (block != null && block.isPresent()) {
                        mapping.remap((Object)block.m_5456_());
                    } else {
                        ItemEntry item = (ItemEntry)GTMaterialItems.MATERIAL_ITEMS.get((Object)prefix, GTCEuAPI.materialManager.getRegistry("gtceu").get(matcher.group(1)));
                        if (item != null && item.isPresent()) {
                            mapping.remap((Object)item.m_5456_());
                        }
                    }
                }
            });
        }
    }
}

