/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import org.apache.commons.lang3.ArrayUtils;

public class WireCombiningHandler {
    private static final TagPrefix[] WIRE_DOUBLING_ORDER = new TagPrefix[]{TagPrefix.wireGtSingle, TagPrefix.wireGtDouble, TagPrefix.wireGtQuadruple, TagPrefix.wireGtOctal, TagPrefix.wireGtHex};
    private static final Map<TagPrefix, TagPrefix> cableToWireMap = ImmutableMap.of((Object)TagPrefix.cableGtSingle, (Object)TagPrefix.wireGtSingle, (Object)TagPrefix.cableGtDouble, (Object)TagPrefix.wireGtDouble, (Object)TagPrefix.cableGtQuadruple, (Object)TagPrefix.wireGtQuadruple, (Object)TagPrefix.cableGtOctal, (Object)TagPrefix.wireGtOctal, (Object)TagPrefix.cableGtHex, (Object)TagPrefix.wireGtHex);

    public static void init(Consumer<FinishedRecipe> provider) {
        TagPrefix.wireGtSingle.executeHandler(provider, PropertyKey.WIRE, WireCombiningHandler::processWireCompression);
        for (TagPrefix wirePrefix : WIRE_DOUBLING_ORDER) {
            wirePrefix.executeHandler(provider, PropertyKey.WIRE, WireCombiningHandler::generateWireCombiningRecipe);
        }
        for (TagPrefix cablePrefix : cableToWireMap.keySet()) {
            cablePrefix.executeHandler(provider, PropertyKey.WIRE, WireCombiningHandler::processCableStripping);
        }
    }

    private static void generateWireCombiningRecipe(TagPrefix wirePrefix, Material material, WireProperties property, Consumer<FinishedRecipe> provider) {
        int wireIndex = ArrayUtils.indexOf((Object[])WIRE_DOUBLING_ORDER, (Object)wirePrefix);
        if (wireIndex < WIRE_DOUBLING_ORDER.length - 1) {
            VanillaRecipeHelper.addShapelessRecipe(provider, String.format("%s_wire_%s_doubling", material.getName(), wirePrefix), ChemicalHelper.get(WIRE_DOUBLING_ORDER[wireIndex + 1], material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material));
        }
        if (wireIndex > 0) {
            VanillaRecipeHelper.addShapelessRecipe(provider, String.format("%s_wire_%s_splitting", material.getName(), wirePrefix), ChemicalHelper.get(WIRE_DOUBLING_ORDER[wireIndex - 1], material, 2), new UnificationEntry(wirePrefix, material));
        }
        if (wireIndex < 3) {
            VanillaRecipeHelper.addShapelessRecipe(provider, String.format("%s_wire_%s_quadrupling", material.getName(), wirePrefix), ChemicalHelper.get(WIRE_DOUBLING_ORDER[wireIndex + 2], material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material));
        }
    }

    private static void processWireCompression(TagPrefix prefix, Material material, WireProperties property, Consumer<FinishedRecipe> provider) {
        for (int startTier = 0; startTier < 4; ++startTier) {
            for (int i = 1; i < 5 - startTier; ++i) {
                GTRecipeTypes.PACKER_RECIPES.recipeBuilder("pack_" + material.getName() + "_wires_" + i + "_" + startTier, new Object[0]).inputItems(WIRE_DOUBLING_ORDER[startTier], material, 1 << i).circuitMeta((int)Math.pow(2.0, i)).outputItems(WIRE_DOUBLING_ORDER[startTier + i], material, 1).save(provider);
            }
        }
        for (int i = 1; i < 5; ++i) {
            GTRecipeTypes.PACKER_RECIPES.recipeBuilder("pack_" + material.getName() + "_wires_" + i + "_single", new Object[0]).inputItems(WIRE_DOUBLING_ORDER[i], material, 1).circuitMeta(1).outputItems(WIRE_DOUBLING_ORDER[0], material, (int)Math.pow(2.0, i)).save(provider);
        }
    }

    private static void processCableStripping(TagPrefix prefix, Material material, WireProperties property, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("strip_" + material.getName() + "_" + prefix.name, new Object[0]).inputItems(prefix, material).outputItems(cableToWireMap.get(prefix), material).outputItems(TagPrefix.plate, GTMaterials.Rubber, (int)(prefix.secondaryMaterials().get(0).amount() / 3628800L)).duration(100).EUt(GTValues.VA[0]).save(provider);
    }
}

