/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.duct;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.pipenet.PipeNetWalker;
import com.gregtechceu.gtceu.common.blockentity.DuctPipeBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeNet;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctRoutePath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuctNetWalker
extends PipeNetWalker<DuctPipeBlockEntity, DuctPipeProperties, DuctPipeNet> {
    private DuctPipeProperties minProperties;
    private final List<DuctRoutePath> inventories;
    private BlockPos sourcePipe;
    private Direction facingToHandler;

    public static List<DuctRoutePath> createNetData(DuctPipeNet pipeNet, BlockPos sourcePipe, Direction sourceFacing) {
        if (!(pipeNet.getLevel().m_7702_(sourcePipe) instanceof DuctPipeBlockEntity)) {
            return null;
        }
        try {
            DuctNetWalker walker = new DuctNetWalker(pipeNet, sourcePipe, 1, new ArrayList<DuctRoutePath>(), null);
            walker.sourcePipe = sourcePipe;
            walker.facingToHandler = sourceFacing;
            walker.traversePipeNet();
            return walker.inventories;
        }
        catch (Exception e) {
            GTCEu.LOGGER.error("error while create net data for DuctPipeNet", (Throwable)e);
            return null;
        }
    }

    protected DuctNetWalker(DuctPipeNet world, BlockPos sourcePipe, int distance, List<DuctRoutePath> inventories, DuctPipeProperties properties) {
        super(world, sourcePipe, distance);
        this.inventories = inventories;
        this.minProperties = properties;
    }

    @Override
    @NotNull
    protected PipeNetWalker<DuctPipeBlockEntity, DuctPipeProperties, DuctPipeNet> createSubWalker(DuctPipeNet pipeNet, Direction facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        DuctNetWalker walker = new DuctNetWalker(pipeNet, nextPos, walkedBlocks, this.inventories, this.minProperties);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        return walker;
    }

    @Override
    protected Class<DuctPipeBlockEntity> getBasePipeClass() {
        return DuctPipeBlockEntity.class;
    }

    @Override
    protected void checkPipe(DuctPipeBlockEntity pipeTile, BlockPos pos) {
        DuctPipeProperties pipeProperties = (DuctPipeProperties)pipeTile.getNodeData();
        this.minProperties = this.minProperties == null ? pipeProperties : new DuctPipeProperties(Math.min(this.minProperties.getTransferRate(), pipeProperties.getTransferRate()));
    }

    @Override
    protected void checkNeighbour(DuctPipeBlockEntity pipeTile, BlockPos pipePos, Direction faceToNeighbour, @Nullable BlockEntity neighbourTile) {
        if (pipePos.equals((Object)this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        if (neighbourTile != null) {
            LazyOptional handler = neighbourTile.getCapability(GTCapability.CAPABILITY_HAZARD_CONTAINER, faceToNeighbour.m_122424_());
            if (handler.isPresent()) {
                this.inventories.add(new DuctRoutePath(pipeTile, faceToNeighbour, this.getWalkedBlocks(), this.minProperties));
            }
        } else if (pipeTile.isConnected(faceToNeighbour)) {
            this.inventories.add(new DuctRoutePath(pipeTile, faceToNeighbour, this.getWalkedBlocks(), this.minProperties));
        }
    }
}

