/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.customlogic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerList;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluidHelper;
import com.gregtechceu.gtceu.core.mixins.PotionBrewingAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class BreweryLogic
implements GTRecipeType.ICustomRecipeLogic {
    @Override
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        IItemHandlerModifiable[] itemInputs = (IItemHandlerModifiable[])Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP), ArrayList::new).stream().filter(IItemHandlerModifiable.class::isInstance).map(IItemHandlerModifiable.class::cast).toArray(IItemHandlerModifiable[]::new);
        IFluidHandler[] fluidInputs = (IFluidHandler[])Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP), ArrayList::new).stream().filter(IFluidHandler.class::isInstance).map(IFluidHandler.class::cast).toArray(IFluidHandler[]::new);
        CombinedInvWrapper combinedItemInputs = new CombinedInvWrapper(itemInputs);
        FluidHandlerList combinedFluidInputs = new FluidHandlerList(fluidInputs);
        for (int i = 0; i < combinedItemInputs.getSlots(); ++i) {
            FluidStack contained;
            int j;
            boolean found;
            ItemStack item = combinedItemInputs.getStackInSlot(i);
            if (item.m_41619_()) continue;
            for (PotionBrewing.Mix<Potion> mix : PotionBrewingAccessor.getPotionMixes()) {
                if (!mix.f_43533_.test(item)) continue;
                FluidStack fromFluid = PotionFluidHelper.getFluidFromPotion((Potion)mix.f_43532_.get(), 750);
                TagKey<Fluid> fromTag = TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_((Object)fromFluid.getFluid()).m_135815_());
                found = false;
                for (j = 0; j < combinedFluidInputs.getTanks(); ++j) {
                    contained = combinedFluidInputs.getFluidInTank(j);
                    if (contained.isEmpty() || !contained.getFluid().m_205067_(fromTag) || !Objects.equals(fromFluid.getTag(), contained.getTag())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                FluidStack toFluid = PotionFluidHelper.getFluidFromPotion((Potion)mix.f_43534_.get(), 750);
                return GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_vanilla_" + ((Potion)mix.f_43534_.get()).m_43492_(""), new Object[0]).inputItems(mix.f_43533_).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
            }
            for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
                if (!(recipe instanceof BrewingRecipe)) continue;
                BrewingRecipe impl = (BrewingRecipe)recipe;
                FluidIngredient fromFluid = PotionFluidHelper.getPotionFluidIngredientFrom(impl.getInput(), 750);
                found = false;
                for (j = 0; j < combinedFluidInputs.getTanks(); ++j) {
                    contained = combinedFluidInputs.getFluidInTank(j);
                    if (contained.isEmpty() || fromFluid.test(contained)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                FluidStack toFluid = PotionFluidHelper.getFluidFromPotionItem(impl.getOutput(), 750);
                String name = toFluid.getFluid().m_205069_().m_205785_().m_135782_().m_135815_();
                Potion output = PotionUtils.m_43579_((ItemStack)impl.getOutput());
                if (output != null) {
                    name = output.m_43492_("");
                }
                return GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_forge_" + name, new Object[0]).inputItems(impl.getIngredient()).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
            }
        }
        return null;
    }

    @Override
    public void buildRepresentativeRecipes() {
        int index = 0;
        for (PotionBrewing.Mix<Potion> mix : PotionBrewingAccessor.getPotionMixes()) {
            FluidStack fromFluid = PotionFluidHelper.getFluidFromPotion((Potion)mix.f_43532_.get(), 750);
            FluidStack toFluid = PotionFluidHelper.getFluidFromPotion((Potion)mix.f_43534_.get(), 750);
            GTRecipe recipe = GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_vanilla_" + ((Potion)mix.f_43534_.get()).m_43492_("") + "_" + index++, new Object[0]).inputItems(mix.f_43533_).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
            recipe.setId(recipe.m_6423_().m_246208_("/"));
            GTRecipeTypes.BREWING_RECIPES.addToMainCategory(recipe);
        }
        for (IBrewingRecipe brewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(brewingRecipe instanceof BrewingRecipe)) continue;
            BrewingRecipe impl = (BrewingRecipe)brewingRecipe;
            FluidIngredient fromFluid = PotionFluidHelper.getPotionFluidIngredientFrom(impl.getInput(), 750);
            FluidStack toFluid = PotionFluidHelper.getFluidFromPotionItem(impl.getOutput(), 750);
            String name = toFluid.getFluid().m_205069_().m_205785_().m_135782_().m_135815_();
            Potion output = PotionUtils.m_43579_((ItemStack)impl.getOutput());
            if (output != null) {
                name = output.m_43492_("");
            }
            GTRecipe recipe = GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_forge_" + name + "_" + index++, new Object[0]).inputItems(impl.getIngredient()).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
            recipe.setId(recipe.m_6423_().m_246208_("/"));
            GTRecipeTypes.BREWING_RECIPES.addToMainCategory(recipe);
        }
    }
}

