/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DrumMachine
extends MetaMachine
implements IAutoOutputFluid,
IDropSaveMachine,
IInteractedMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DrumMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    private final int maxStoredFluids;
    @Persisted
    protected final NotifiableFluidTank cache;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportFluidSubs;
    @Persisted(key="Fluid")
    @DescSynced
    @DropSaved
    protected FluidStack stored = FluidStack.EMPTY;
    protected final Material material;

    public DrumMachine(IMachineBlockEntity holder, Material material, int maxStoredFluids, Object ... args) {
        super(holder);
        this.material = material;
        this.maxStoredFluids = maxStoredFluids;
        this.cache = this.createCacheFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, this.maxStoredFluids, IO.BOTH).setFilter(this.material.getProperty(PropertyKey.FLUID_PIPE));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateStoredFluidFromCache();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
        this.exportFluidSubs = this.cache.addChangedListener(this::onFluidChanged);
    }

    private void onFluidChanged() {
        if (!this.isRemote()) {
            this.updateStoredFluidFromCache();
            this.updateAutoOutputSubscription();
        }
    }

    private void updateStoredFluidFromCache() {
        FluidStack cachedFluid = this.cache.getFluidInTank(0);
        this.stored = cachedFluid.isEmpty() ? FluidStack.EMPTY : cachedFluid;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportFluidSubs != null) {
            this.exportFluidSubs.unsubscribe();
            this.exportFluidSubs = null;
        }
    }

    @Override
    public void loadFromItem(CompoundTag tag) {
        IDropSaveMachine.super.loadFromItem(tag);
        if (!tag.m_128441_("Fluid")) {
            this.stored = FluidStack.EMPTY;
        }
        this.cache.getStorages()[0].setFluid(this.stored.copy());
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        this.autoOutputFluids = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allow) {
    }

    @Override
    public void setOutputFacingFluids(@Nullable Direction outputFacing) {
        this.updateAutoOutputSubscription();
    }

    @Override
    @Nullable
    public Direction getOutputFacingFluids() {
        return Direction.DOWN;
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingFluids();
        if (this.isAutoOutputFluids() && !this.cache.isEmpty() && outputFacing != null && GTTransferUtils.hasAdjacentFluidHandler(this.getLevel(), this.getPos(), outputFacing)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.cache.exportToNearby(this.getOutputFacingFluids());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isRemote() && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.cache)) {
            return InteractionResult.SUCCESS;
        }
        return world.f_46443_ ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public boolean saveBreak() {
        return !this.stored.isEmpty();
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote() && !playerIn.m_6144_()) {
            this.setAutoOutputFluids(!this.isAutoOutputFluids());
            playerIn.m_213846_((Component)Component.m_237115_((String)("gtceu.machine.drum." + (this.autoOutputFluids ? "enable" : "disable") + "_output")));
            return InteractionResult.SUCCESS;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.SCREWDRIVER) && side == this.getOutputFacingFluids()) {
            return this.isAutoOutputFluids() ? GuiTextures.TOOL_DISABLE_AUTO_OUTPUT : GuiTextures.TOOL_AUTO_OUTPUT;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    public int getMaxStoredFluids() {
        return this.maxStoredFluids;
    }

    public FluidStack getStored() {
        return this.stored;
    }

    public Material getMaterial() {
        return this.material;
    }
}

