/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomSlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CreativeChestMachine
extends QuantumChestMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CreativeChestMachine.class, QuantumChestMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DropSaved
    private int itemsPerCycle = 1;
    @Persisted
    @DropSaved
    private int ticksPerCycle = 1;

    public CreativeChestMachine(IMachineBlockEntity holder) {
        super(holder, 14, -1L, new Object[0]);
    }

    @Override
    protected QuantumChestMachine.ItemCache createCacheItemHandler(Object ... args) {
        return new InfiniteCache((MetaMachine)this);
    }

    @Override
    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % (long)this.ticksPerCycle == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    private InteractionResult updateStored(ItemStack item) {
        this.stored = item.m_255036_(1);
        this.onItemChanged();
        return InteractionResult.SUCCESS;
    }

    private void setTicksPerCycle(String value) {
        if (value.isEmpty()) {
            return;
        }
        this.ticksPerCycle = Integer.parseInt(value);
        this.onItemChanged();
    }

    private void setItemsPerCycle(String value) {
        if (value.isEmpty()) {
            return;
        }
        this.itemsPerCycle = Integer.parseInt(value);
        this.onItemChanged();
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (hit.m_82434_() == this.getFrontFacing() && !this.isRemote()) {
            if (heldItem.m_41619_() && player.m_6047_() && !this.stored.m_41619_()) {
                return this.updateStored(ItemStack.f_41583_);
            }
            if (!heldItem.m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)this.stored, (ItemStack)heldItem)) {
                player.m_21008_(hand, ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_()) {
                return this.updateStored(heldItem);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 131);
        group.addWidget((Widget)new PhantomSlotWidget(this.cache, 0, 36, 6).setClearSlotOnRightClick(true).setMaxStackSize(1).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setChangeListener(this::markDirty));
        group.addWidget((Widget)new LabelWidget(7, 9, "gtceu.creative.chest.item"));
        group.addWidget((Widget)new ImageWidget(7, 48, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 50, 152, 10, () -> String.valueOf(this.itemsPerCycle), this::setItemsPerCycle).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 28, "gtceu.creative.chest.ipc"));
        group.addWidget((Widget)new ImageWidget(7, 85, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 87, 152, 10, () -> String.valueOf(this.ticksPerCycle), this::setTicksPerCycle).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 65, "gtceu.creative.chest.tpc"));
        group.addWidget((Widget)new SwitchWidget(7, 101, 162, 20, (clickData, value) -> this.setWorkingEnabled((boolean)value)).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.off")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.on")})).setPressed(this.isWorkingEnabled()));
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public int getItemsPerCycle() {
        return this.itemsPerCycle;
    }

    public int getTicksPerCycle() {
        return this.ticksPerCycle;
    }

    private class InfiniteCache
    extends QuantumChestMachine.ItemCache {
        public InfiniteCache(MetaMachine holder) {
            super(CreativeChestMachine.this, holder);
        }

        @Override
        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return CreativeChestMachine.this.stored;
        }

        @Override
        public void setStackInSlot(int index, ItemStack stack) {
            CreativeChestMachine.this.updateStored(stack);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!CreativeChestMachine.this.stored.m_41619_() && ItemStack.m_150942_((ItemStack)CreativeChestMachine.this.stored, (ItemStack)stack)) {
                return ItemStack.f_41583_;
            }
            return stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!CreativeChestMachine.this.stored.m_41619_()) {
                return CreativeChestMachine.this.stored.m_255036_(CreativeChestMachine.this.itemsPerCycle);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

