/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class PlayerOwner
implements IMachineOwner {
    private UUID playerUUID;

    public PlayerOwner() {
    }

    public PlayerOwner(UUID player) {
        this.playerUUID = player;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128362_("UUID", this.playerUUID);
    }

    @Override
    public void load(CompoundTag tag) {
        this.playerUUID = tag.m_128342_("UUID");
    }

    @Override
    public boolean isPlayerInTeam(Player player) {
        return true;
    }

    @Override
    public boolean isPlayerFriendly(Player player) {
        return true;
    }

    @Override
    public void displayInfo(List<Component> compList) {
        boolean isOnline;
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.machine_ownership", (Object[])new Object[]{this.type().getName()}));
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.playerUUID);
        String[] playerName = new String[1];
        if (serverPlayer != null) {
            playerName[0] = serverPlayer.m_5446_().getString();
            isOnline = true;
        } else {
            GameProfileCache cache = ServerLifecycleHooks.getCurrentServer().m_129927_();
            if (cache != null) {
                cache.m_11002_(this.playerUUID).ifPresent(value -> {
                    playerName[0] = value.getName();
                });
            }
            isOnline = false;
        }
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.player_name", (Object[])new Object[]{playerName[0], isOnline}));
    }

    @Override
    public IMachineOwner.MachineOwnerType type() {
        return IMachineOwner.MachineOwnerType.PLAYER;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

