/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.item.tool.behavior.LighterBehavior;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CharcoalPileIgniterMachine
extends WorkableMultiblockMachine
implements IWorkable {
    private static final Set<Block> WALL_BLOCKS = new ObjectOpenHashSet();
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER;
    private final Collection<BlockPos> logPos = new ObjectOpenHashSet();
    private static final int MIN_RADIUS = 1;
    private static final int MIN_DEPTH = 2;
    @DescSynced
    private int lDist = 0;
    @DescSynced
    private int rDist = 0;
    @DescSynced
    private int bDist = 0;
    @DescSynced
    private int fDist = 0;
    @DescSynced
    private int hDist = 0;
    @DescSynced
    @RequireRerender
    private boolean isActive;
    private int progressTime = 0;
    private int maxTime = 0;
    private TickableSubscription burnLogsSubscription;

    public CharcoalPileIgniterMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.updateMaxProgessTime();
        this.burnLogsSubscription = this.subscribeServerTick(this::tick);
        this.tick();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.resetState();
        this.progressTime = 0;
        this.maxTime = 0;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.resetState();
    }

    private void resetState() {
        this.unsubscribe(this.burnLogsSubscription);
        this.isActive = false;
    }

    @Override
    public int getProgress() {
        return this.progressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxTime;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isWorkingEnabled() {
        return true;
    }

    @Override
    public BlockPattern getPattern() {
        int j;
        int i;
        this.updateDimensions();
        if (this.lDist < 1) {
            this.lDist = 1;
        }
        if (this.rDist < 1) {
            this.rDist = 1;
        }
        if (this.hDist < 2) {
            this.hDist = 1;
        }
        if (this.getFrontFacing().m_122434_() == Direction.Axis.X) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder[] floorLayer = new StringBuilder[this.fDist + this.bDist + 1];
        ArrayList<StringBuilder[]> wallLayers = new ArrayList<StringBuilder[]>();
        StringBuilder[] ceilingLayer = new StringBuilder[this.fDist + this.bDist + 1];
        for (i = 0; i < floorLayer.length; ++i) {
            floorLayer[i] = new StringBuilder(this.lDist + this.rDist + 1);
            ceilingLayer[i] = new StringBuilder(this.lDist + this.rDist + 1);
        }
        for (i = 0; i < this.hDist - 1; ++i) {
            wallLayers.add(new StringBuilder[this.fDist + this.bDist + 1]);
            for (j = 0; j < this.fDist + this.bDist + 1; ++j) {
                StringBuilder s;
                ((StringBuilder[])wallLayers.get((int)i))[j] = s = new StringBuilder(this.lDist + this.rDist + 3);
            }
        }
        for (i = 0; i < this.lDist + this.rDist + 1; ++i) {
            for (j = 0; j < this.fDist + this.bDist + 1; ++j) {
                int k;
                if (i == 0 || i == this.lDist + this.rDist || j == 0 || j == this.fDist + this.bDist) {
                    floorLayer[i].append('A');
                    for (k = 0; k < this.hDist - 1; ++k) {
                        if (!(i != 0 && i != this.lDist + this.rDist || j != 0 && j != this.fDist + this.bDist)) {
                            ((StringBuilder[])wallLayers.get(k))[i].append('A');
                            continue;
                        }
                        ((StringBuilder[])wallLayers.get(k))[i].append('W');
                    }
                    ceilingLayer[i].append('A');
                    continue;
                }
                if (i == this.lDist && j == this.fDist) {
                    floorLayer[i].append('B');
                } else {
                    floorLayer[i].append('B');
                }
                for (k = 0; k < this.hDist - 1; ++k) {
                    ((StringBuilder[])wallLayers.get(k))[i].append('L');
                }
                if (i == this.lDist && j == this.fDist) {
                    ceilingLayer[i].append('S');
                    continue;
                }
                ceilingLayer[i].append('W');
            }
        }
        String[] f = new String[this.bDist + this.fDist + 1];
        for (int i2 = 0; i2 < floorLayer.length; ++i2) {
            f[i2] = floorLayer[i2].toString();
        }
        String[] m = new String[this.bDist + this.fDist + 1];
        for (int i3 = 0; i3 < ((StringBuilder[])wallLayers.get(0)).length; ++i3) {
            m[i3] = ((StringBuilder[])wallLayers.get(0))[i3].toString();
        }
        String[] c = new String[this.bDist + this.fDist + 1];
        for (int i4 = 0; i4 < ceilingLayer.length; ++i4) {
            c[i4] = ceilingLayer[i4].toString();
        }
        return FactoryBlockPattern.start(RelativeDirection.LEFT, RelativeDirection.FRONT, RelativeDirection.UP).aisle(f).aisle(m).setRepeatable(wallLayers.size()).aisle(c).where('S', Predicates.controller(Predicates.blocks(this.getDefinition().get()))).where('B', Predicates.blocks(Blocks.f_50076_)).where('W', this.wallPredicate()).where('L', this.logPredicate()).where('A', Predicates.any()).build();
    }

    private TraceabilityPredicate wallPredicate() {
        return new TraceabilityPredicate(multiblockState -> {
            boolean match = false;
            for (Block b : WALL_BLOCKS) {
                if (multiblockState.getBlockState().m_60734_() != b) continue;
                match = true;
                break;
            }
            return match;
        }, null);
    }

    private TraceabilityPredicate logPredicate() {
        return new TraceabilityPredicate(multiblockState -> {
            if (multiblockState.getBlockState().m_204336_(BlockTags.f_13105_)) {
                this.logPos.add(multiblockState.getPos());
                return true;
            }
            return false;
        }, null);
    }

    public void updateDimensions() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        Direction front = this.getFrontFacing();
        Direction back = front.m_122424_();
        Direction left = front.m_122428_();
        Direction right = left.m_122424_();
        BlockPos.MutableBlockPos lPos = this.getPos().m_122032_().m_122173_(Direction.DOWN);
        BlockPos.MutableBlockPos rPos = this.getPos().m_122032_().m_122173_(Direction.DOWN);
        BlockPos.MutableBlockPos fPos = this.getPos().m_122032_().m_122173_(Direction.DOWN);
        BlockPos.MutableBlockPos bPos = this.getPos().m_122032_().m_122173_(Direction.DOWN);
        BlockPos.MutableBlockPos hPos = this.getPos().m_122032_();
        int lDist = 0;
        int rDist = 0;
        int bDist = 0;
        int fDist = 0;
        int hDist = 0;
        for (int i = 1; i < 6 && (lDist == 0 || rDist == 0 || hDist == 0); ++i) {
            if (lDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, rPos, right)) {
                rDist = i;
            }
            if (bDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, bPos, back)) {
                bDist = i;
            }
            if (fDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, fPos, front)) {
                fDist = i;
            }
            if (hDist != 0 || !CharcoalPileIgniterMachine.isBlockFloor(level, hPos)) continue;
            hDist = i;
        }
        if (Math.abs(lDist - rDist) > 1 || Math.abs(bDist - fDist) > 1) {
            this.isFormed = false;
            return;
        }
        if (lDist < 1 || rDist < 1 || fDist < 1 || bDist < 1 || hDist < 2) {
            this.isFormed = false;
            return;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.fDist = fDist;
        this.bDist = bDist;
        this.hDist = hDist;
    }

    private static boolean isBlockWall(Level level, BlockPos.MutableBlockPos pos, Direction direction) {
        return WALL_BLOCKS.contains(level.m_8055_((BlockPos)pos.m_122173_(direction)).m_60734_());
    }

    private static boolean isBlockFloor(Level level, BlockPos.MutableBlockPos pos) {
        return level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN)).m_60734_() == Blocks.f_50076_;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    private void updateMaxProgessTime() {
        this.maxTime = Math.max(1, (int)Math.sqrt(this.logPos.size() * 240000));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.isActive) {
            BlockPos pos = this.getPos();
            Direction facing = Direction.UP;
            float xPos = (float)facing.m_122429_() * 0.76f + (float)pos.m_123341_() + 0.25f + GTValues.RNG.m_188501_() / 2.0f;
            float yPos = (float)facing.m_122430_() * 0.76f + (float)pos.m_123342_() + 0.25f;
            float zPos = (float)facing.m_122431_() * 0.76f + (float)pos.m_123343_() + 0.25f + GTValues.RNG.m_188501_() / 2.0f;
            float ySpd = (float)facing.m_122430_() * 0.1f + 0.01f * GTValues.RNG.m_188501_();
            float horSpd = 0.03f * GTValues.RNG.m_188501_();
            float horSpd2 = 0.03f * GTValues.RNG.m_188501_();
            if (GTValues.RNG.m_188501_() < 0.1f) {
                this.getLevel().m_7785_((double)xPos, (double)yPos, (double)zPos, SoundEvents.f_11784_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            for (float xi = xPos - 1.0f; xi <= xPos + 1.0f; xi += 1.0f) {
                for (float zi = zPos - 1.0f; zi <= zPos + 1.0f; zi += 1.0f) {
                    if (GTValues.RNG.m_188501_() < 0.9f) continue;
                    this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)xi, (double)yPos, (double)zi, (double)horSpd, (double)ySpd, (double)horSpd2);
                }
            }
        }
    }

    public void tick() {
        if (this.isActive && this.maxTime > 0 && ++this.progressTime == this.maxTime) {
            this.progressTime = 0;
            this.maxTime = 0;
            this.convertLogBlocks();
            this.isActive = false;
        }
    }

    private void convertLogBlocks() {
        Level level = this.getLevel();
        for (BlockPos pos : this.logPos) {
            level.m_7731_(pos, GTBlocks.BRITTLE_CHARCOAL.getDefaultState(), 3);
        }
        this.logPos.clear();
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        CharcoalPileIgniterMachine cpi;
        IMachineBlockEntity machineBe;
        MetaMachine mte;
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IMachineBlockEntity && (mte = (machineBe = (IMachineBlockEntity)be).getMetaMachine()) instanceof CharcoalPileIgniterMachine && (cpi = (CharcoalPileIgniterMachine)mte).isFormed()) {
            if (world.f_46443_) {
                player.m_6674_(hand);
            } else if (!cpi.isActive()) {
                boolean shouldActivate = false;
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41720_() instanceof FlintAndSteelItem) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    this.getLevel().m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    shouldActivate = true;
                } else if (stack.m_41720_() instanceof FireChargeItem) {
                    stack.m_41774_(1);
                    this.getLevel().m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    shouldActivate = true;
                } else {
                    Item item = stack.m_41720_();
                    if (item instanceof ComponentItem) {
                        ComponentItem compItem = (ComponentItem)item;
                        for (IItemComponent component : compItem.getComponents()) {
                            LighterBehavior lighter;
                            if (!(component instanceof LighterBehavior) || !(lighter = (LighterBehavior)component).consumeFuel(player, stack)) continue;
                            this.getLevel().m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            shouldActivate = true;
                            break;
                        }
                    }
                }
                if (shouldActivate) {
                    cpi.setActive(true);
                    return InteractionResult.CONSUME;
                }
            }
        }
        return super.onUse(state, world, pos, player, hand, hit);
    }

    static {
        WALL_BLOCKS.add(Blocks.f_50493_);
        WALL_BLOCKS.add(Blocks.f_50546_);
        WALL_BLOCKS.add(Blocks.f_50599_);
        WALL_BLOCKS.add(Blocks.f_50440_);
        WALL_BLOCKS.add(Blocks.f_152481_);
        WALL_BLOCKS.add(Blocks.f_49992_);
        WALL_BLOCKS.add(Blocks.f_49993_);
        MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CharcoalPileIgniterMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    }
}

