/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.RecipeIterator;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DistillationTowerMachine
extends WorkableElectricMultiblockMachine
implements FluidRecipeCapability.ICustomParallel {
    private List<IFluidHandler> fluidOutputs;
    @Nullable
    private IFluidHandler firstValid = null;
    private final int yOffset;

    public DistillationTowerMachine(IMachineBlockEntity holder) {
        this(holder, 1);
    }

    public DistillationTowerMachine(IMachineBlockEntity holder, int yOffset) {
        super(holder, new Object[0]);
        this.yOffset = yOffset;
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new DistillationTowerLogic(this);
    }

    @Override
    public DistillationTowerLogic getRecipeLogic() {
        return (DistillationTowerLogic)super.getRecipeLogic();
    }

    @Override
    public void onStructureFormed() {
        this.getDefinition().setPartSorter(Comparator.comparingInt(p -> p.self().getPos().m_123342_()));
        this.getDefinition().setAllowExtendedFacing(false);
        super.onStructureFormed();
        int startY = this.getPos().m_123342_() + this.yOffset;
        List<IMultiPart> parts = this.getParts().stream().filter(part -> PartAbility.EXPORT_FLUIDS.isApplicable(part.self().getBlockState().m_60734_())).filter(part -> part.self().getPos().m_123342_() >= startY).toList();
        if (!parts.isEmpty()) {
            int maxY = parts.get(parts.size() - 1).self().getPos().m_123342_();
            this.fluidOutputs = new ObjectArrayList(maxY - startY);
            int outputIndex = 0;
            for (int y = startY; y <= maxY; ++y) {
                if (parts.size() <= outputIndex) {
                    this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
                    continue;
                }
                IMultiPart part2 = parts.get(outputIndex);
                if (part2.self().getPos().m_123342_() == y) {
                    IFluidHandler handler = part2.getRecipeHandlers().stream().filter(IFluidHandler.class::isInstance).findFirst().map(IFluidHandler.class::cast).orElse((IFluidHandler)VoidFluidHandler.INSTANCE);
                    this.addOutput(handler);
                    ++outputIndex;
                    continue;
                }
                if (part2.self().getPos().m_123342_() > y) {
                    this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
                    continue;
                }
                GTCEu.LOGGER.error("The Distillation Tower at {} has a fluid export hatch with an unexpected Y position", (Object)this.getPos());
                this.onStructureInvalid();
                return;
            }
        } else {
            this.onStructureInvalid();
        }
    }

    private void addOutput(IFluidHandler handler) {
        this.fluidOutputs.add(handler);
        if (this.firstValid == null && handler != VoidFluidHandler.INSTANCE) {
            this.firstValid = handler;
        }
    }

    @Override
    public void onStructureInvalid() {
        this.fluidOutputs = null;
        this.firstValid = null;
        super.onStructureInvalid();
    }

    @Override
    public int limitParallel(GTRecipe recipe, int multiplier) {
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        int maxAmount = recipe.getOutputContents(FluidRecipeCapability.CAP).stream().map(Content::getContent).map(FluidRecipeCapability.CAP::of).filter(i -> !i.isEmpty()).map(i -> i.getStacks()[0]).mapToInt(FluidStack::getAmount).max().orElse(0);
        if (maxAmount == 0) {
            return multiplier;
        }
        while (minMultiplier != maxMultiplier) {
            if (multiplier > Integer.MAX_VALUE / maxAmount) {
                multiplier = Integer.MAX_VALUE / maxAmount;
            }
            GTRecipe copy = recipe.copy(ContentModifier.multiplier(multiplier), false);
            boolean filled = this.getRecipeLogic().applyFluidOutputs(copy, IFluidHandler.FluidAction.SIMULATE);
            int[] bin = ParallelLogic.adjustMultiplier(filled, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = bin[0];
            multiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return multiplier;
    }

    public List<IFluidHandler> getFluidOutputs() {
        return this.fluidOutputs;
    }

    @Nullable
    public IFluidHandler getFirstValid() {
        return this.firstValid;
    }

    public static class DistillationTowerLogic
    extends RecipeLogic {
        @Persisted
        @DescSynced
        @Nullable
        GTRecipe workingRecipe = null;

        public DistillationTowerLogic(IRecipeLogicMachine machine) {
            super(machine);
        }

        @Override
        @NotNull
        public DistillationTowerMachine getMachine() {
            return (DistillationTowerMachine)super.getMachine();
        }

        @Override
        @Nullable
        public GTRecipe getLastRecipe() {
            return this.workingRecipe;
        }

        @Override
        @Nullable
        public Iterator<GTRecipe> searchRecipe() {
            GTRecipeType recipeType = this.machine.getRecipeType();
            if (recipeType == GTRecipeTypes.DISTILLERY_RECIPES) {
                return super.searchRecipe();
            }
            IRecipeLogicMachine holder = this.machine;
            if (!holder.hasProxies()) {
                return null;
            }
            RecipeIterator iterator = recipeType.getLookup().getRecipeIterator(holder, recipe -> !recipe.isFuel && this.matchDTRecipe((GTRecipe)recipe, holder).isSuccess() && recipe.matchTickRecipe(holder).isSuccess());
            boolean any = false;
            while (iterator.hasNext()) {
                GTRecipe recipe2 = iterator.next();
                if (recipe2 == null) continue;
                any = true;
                break;
            }
            if (any) {
                iterator.reset();
                return iterator;
            }
            for (GTRecipeType.ICustomRecipeLogic logic : recipeType.getCustomRecipeLogicRunners()) {
                GTRecipe recipe3 = logic.createCustomRecipe(holder);
                if (recipe3 == null) continue;
                return Collections.singleton(recipe3).iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        public void findAndHandleRecipe() {
            this.lastFailedMatches = null;
            if (!this.recipeDirty && this.lastRecipe != null && this.matchDTRecipe(this.lastRecipe, this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
                GTRecipe recipe = this.lastRecipe;
                this.lastRecipe = null;
                this.lastOriginRecipe = null;
                this.setupRecipe(recipe);
            } else {
                this.workingRecipe = null;
                this.lastRecipe = null;
                this.lastOriginRecipe = null;
                this.handleSearchingRecipes(this.searchRecipe());
            }
        }

        @Override
        public boolean checkMatchedRecipeAvailable(GTRecipe match) {
            GTRecipe matchCopy = match.copy();
            GTRecipe modified = this.machine.fullModifyRecipe(matchCopy);
            if (modified != null) {
                if (modified.checkConditions(this).isSuccess() && this.matchDTRecipe(modified, this.machine).isSuccess() && modified.matchTickRecipe(this.machine).isSuccess()) {
                    this.setupRecipe(modified);
                }
                if (this.lastRecipe != null && this.getStatus() == RecipeLogic.Status.WORKING) {
                    this.lastOriginRecipe = match;
                    this.lastFailedMatches = null;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onRecipeFinish() {
            this.machine.afterWorking();
            if (this.lastRecipe != null) {
                this.lastRecipe.postWorking(this.machine);
                this.handleRecipeIO(this.lastRecipe, IO.OUT);
                if (this.machine.alwaysTryModifyRecipe()) {
                    if (this.lastOriginRecipe != null) {
                        GTRecipe modified = this.machine.fullModifyRecipe(this.lastOriginRecipe.copy());
                        if (modified == null) {
                            this.markLastRecipeDirty();
                        } else {
                            this.lastRecipe = modified;
                        }
                    } else {
                        this.markLastRecipeDirty();
                    }
                }
                if (!this.recipeDirty && !this.suspendAfterFinish && this.matchDTRecipe(this.lastRecipe, this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
                    this.setupRecipe(this.lastRecipe);
                    if (this.isActive) {
                        ++this.consecutiveRecipes;
                    }
                } else {
                    if (this.suspendAfterFinish) {
                        this.setStatus(RecipeLogic.Status.SUSPEND);
                        this.suspendAfterFinish = false;
                    } else {
                        this.setStatus(RecipeLogic.Status.IDLE);
                    }
                    this.consecutiveRecipes = 0;
                    this.progress = 0;
                    this.duration = 0;
                    this.isActive = false;
                }
            }
        }

        private GTRecipe.ActionResult matchDTRecipe(GTRecipe recipe, IRecipeCapabilityHolder holder) {
            Map<RecipeCapability<?>, List<Content>> out;
            GTRecipe.ActionResult result = recipe.matchRecipeContents(IO.IN, holder, recipe.inputs, false);
            if (!result.isSuccess()) {
                return result;
            }
            List<Content> items = recipe.getOutputContents(ItemRecipeCapability.CAP);
            if (!items.isEmpty() && !(result = recipe.matchRecipeContents(IO.OUT, holder, out = Map.of(ItemRecipeCapability.CAP, items), false)).isSuccess()) {
                return result;
            }
            if (!this.applyFluidOutputs(recipe, IFluidHandler.FluidAction.SIMULATE)) {
                return GTRecipe.ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_(FluidRecipeCapability.CAP.getName()));
            }
            return GTRecipe.ActionResult.SUCCESS;
        }

        private void updateWorkingRecipe(GTRecipe recipe) {
            if (recipe.recipeType == GTRecipeTypes.DISTILLERY_RECIPES) {
                this.workingRecipe = recipe;
                return;
            }
            this.workingRecipe = recipe.copy();
            List<Content> contents = recipe.getOutputContents(FluidRecipeCapability.CAP);
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            ArrayList<Content> trimmed = new ArrayList<Content>(12);
            for (int i = 0; i < Math.min(contents.size(), outputs.size()); ++i) {
                if (outputs.get(i) instanceof VoidFluidHandler) continue;
                trimmed.add(contents.get(i));
            }
            this.workingRecipe.outputs.put(FluidRecipeCapability.CAP, trimmed);
        }

        @Override
        protected boolean handleRecipeIO(GTRecipe recipe, IO io) {
            if (io != IO.OUT) {
                if (super.handleRecipeIO(recipe, io)) {
                    this.updateWorkingRecipe(recipe);
                    return true;
                }
                this.workingRecipe = null;
                return false;
            }
            List<Content> items = recipe.getOutputContents(ItemRecipeCapability.CAP);
            if (!items.isEmpty()) {
                Map<RecipeCapability<?>, List<Content>> out = Map.of(ItemRecipeCapability.CAP, items);
                recipe.handleRecipe(io, this.machine, false, out, this.chanceCaches);
            }
            return this.applyFluidOutputs(recipe, IFluidHandler.FluidAction.EXECUTE);
        }

        private boolean applyFluidOutputs(GTRecipe recipe, IFluidHandler.FluidAction action) {
            List<FluidIngredient> fluids = recipe.getOutputContents(FluidRecipeCapability.CAP).stream().map(Content::getContent).map(FluidRecipeCapability.CAP::of).toList();
            if (recipe.recipeType == GTRecipeTypes.DISTILLERY_RECIPES) {
                int n;
                FluidStack fluid = fluids.get(0).getStacks()[0];
                IFluidHandler handler = this.getMachine().getFirstValid();
                if (handler == null) {
                    return false;
                }
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank nft = (NotifiableFluidTank)handler;
                    n = nft.fillInternal(fluid, action);
                } else {
                    n = handler.fill(fluid, action);
                }
                int filled = n;
                return filled == fluid.getAmount();
            }
            boolean valid = true;
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            for (int i = 0; i < Math.min(fluids.size(), outputs.size()); ++i) {
                int filled;
                IFluidHandler handler = outputs.get(i);
                FluidStack fluid = fluids.get(i).getStacks()[0];
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank nft = (NotifiableFluidTank)handler;
                    v1 = nft.fillInternal(fluid, action);
                } else {
                    v1 = filled = handler.fill(fluid, action);
                }
                if (filled != fluid.getAmount()) {
                    valid = false;
                }
                if (action.simulate() && !valid) break;
            }
            return valid;
        }
    }
}

