/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolModeSwitchBehavior
implements IToolBehavior {
    public static final ToolModeSwitchBehavior INSTANCE = new ToolModeSwitchBehavior();

    protected ToolModeSwitchBehavior() {
    }

    @Override
    public void addBehaviorNBT(@NotNull ItemStack stack, @NotNull CompoundTag tag) {
        Set<GTToolType> toolTypes = ToolHelper.getToolTypes(stack);
        if (toolTypes.contains(GTToolType.WRENCH)) {
            tag.m_128344_("Mode", (byte)WrenchModeType.BOTH.ordinal());
        }
        IToolBehavior.super.addBehaviorNBT(stack, tag);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> onItemRightClick(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        CompoundTag tagCompound = ToolHelper.getBehaviorsTag(itemStack);
        if (player.m_6144_()) {
            Set<GTToolType> toolTypes = ToolHelper.getToolTypes(itemStack);
            if (toolTypes.contains(GTToolType.WRENCH)) {
                tagCompound.m_128344_("Mode", (byte)((tagCompound.m_128445_("Mode") + 1) % WrenchModeType.values().length));
                player.m_5661_((Component)Component.m_237110_((String)"metaitem.machine_configuration.mode", (Object[])new Object[]{WrenchModeType.values()[tagCompound.m_128445_("Mode")].getName()}), true);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return IToolBehavior.super.onItemRightClick(world, player, hand);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        CompoundTag tagCompound = ToolHelper.getBehaviorsTag(stack);
        Set<GTToolType> toolTypes = ToolHelper.getToolTypes(stack);
        if (toolTypes.contains(GTToolType.WRENCH)) {
            tooltip.add((Component)Component.m_237110_((String)"metaitem.machine_configuration.mode", (Object[])new Object[]{WrenchModeType.values()[tagCompound.m_128445_("Mode")].getName()}));
        }
    }

    public static enum WrenchModeType {
        ITEM((Component)Component.m_237115_((String)"gtceu.mode.item")),
        FLUID((Component)Component.m_237115_((String)"gtceu.mode.fluid")),
        BOTH((Component)Component.m_237115_((String)"gtceu.mode.both"));

        private final Component name;

        private WrenchModeType(Component name) {
            this.name = name;
        }

        public Component getName() {
            return this.name;
        }
    }
}

