/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDamageBehavior
implements IToolBehavior {
    private final List<Function<LivingEntity, Float>> shouldDoBonusList = new ArrayList<Function<LivingEntity, Float>>();
    private final String mobType;

    public EntityDamageBehavior(float bonus, Class<?> ... entities) {
        this(null, bonus, entities);
    }

    public EntityDamageBehavior(Map<Class<?>, Float> entities) {
        this(null, entities);
    }

    public EntityDamageBehavior(String mobType, float bonus, Class<?> ... entities) {
        this.mobType = mobType;
        for (Class<?> entity : entities) {
            this.shouldDoBonusList.add(e -> Float.valueOf(entity.isAssignableFrom(e.getClass()) ? bonus : 0.0f));
        }
    }

    public EntityDamageBehavior(String mobType, Map<Class<?>, Float> entities) {
        this.mobType = mobType;
        for (Map.Entry<Class<?>, Float> entry : entities.entrySet()) {
            Class<?> entity = entry.getKey();
            float bonus = entry.getValue().floatValue();
            this.shouldDoBonusList.add(e -> Float.valueOf(entity.isAssignableFrom(e.getClass()) ? bonus : 0.0f));
        }
    }

    @Override
    public void hitEntity(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        float damageBonus = this.shouldDoBonusList.stream().map(func -> (Float)func.apply(target)).filter(f -> f.floatValue() > 0.0f).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
        if (damageBonus != 0.0f) {
            DamageSource damageSource;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                damageSource = attacker.m_269291_().m_269075_(player);
            } else {
                damageSource = attacker.m_269291_().m_269333_(attacker);
            }
            DamageSource source = damageSource;
            target.m_6469_(source, damageBonus);
        }
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.mobType != null && !this.mobType.isEmpty()) {
            tooltip.add((Component)Component.m_237110_((String)"item.gtceu.tool.behavior.damage_boost", (Object[])new Object[]{Component.m_237115_((String)("item.gtceu.tool.behavior.damage_boost_" + this.mobType))}));
        }
    }
}

