/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CoilWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GTRecipeModifiers {
    public static final Function<OverclockingLogic, RecipeModifier> ELECTRIC_OVERCLOCK = Util.m_143827_(logic -> (machine, recipe) -> {
        if (!(machine instanceof IOverclockMachine)) {
            return ModifierFunction.IDENTITY;
        }
        IOverclockMachine overclockMachine = (IOverclockMachine)((Object)machine);
        if (RecipeHelper.getRecipeEUtTier(recipe) > overclockMachine.getMaxOverclockTier()) {
            return ModifierFunction.NULL;
        }
        return logic.getModifier(machine, recipe, overclockMachine.getOverclockVoltage());
    });
    public static final RecipeModifier OC_PERFECT = ELECTRIC_OVERCLOCK.apply(OverclockingLogic.PERFECT_OVERCLOCK);
    public static final RecipeModifier OC_NON_PERFECT = ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK);
    public static final RecipeModifier OC_PERFECT_SUBTICK = ELECTRIC_OVERCLOCK.apply(OverclockingLogic.PERFECT_OVERCLOCK_SUBTICK);
    public static final RecipeModifier OC_NON_PERFECT_SUBTICK = ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK);
    public static final BiFunction<MedicalCondition, Integer, RecipeModifier> ENVIRONMENT_REQUIREMENT = Util.m_143821_((condition, maxAllowedStrength) -> (machine, recipe) -> {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return ModifierFunction.IDENTITY;
        }
        Level patt3034$temp = machine.getLevel();
        if (!(patt3034$temp instanceof ServerLevel)) {
            return ModifierFunction.NULL;
        }
        ServerLevel serverLevel = (ServerLevel)patt3034$temp;
        EnvironmentalHazardSavedData data = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
        BlockPos machinePos = machine.getPos();
        EnvironmentalHazardSavedData.HazardZone zone = data.getZoneByContainedPosAndCondition(machinePos, (MedicalCondition)condition);
        if (zone == null) {
            return ModifierFunction.IDENTITY;
        }
        float strength = zone.strength();
        if (strength > (float)maxAllowedStrength.intValue()) {
            return ModifierFunction.NULL;
        }
        int multiplier = 1 + (int)(strength * 5.0f / (float)maxAllowedStrength.intValue());
        if (multiplier > 5) {
            return ModifierFunction.NULL;
        }
        return ModifierFunction.builder().durationMultiplier(multiplier).build();
    });
    public static final RecipeModifier DEFAULT_ENVIRONMENT_REQUIREMENT = ENVIRONMENT_REQUIREMENT.apply(GTMedicalConditions.CARBON_MONOXIDE_POISONING, 1000);
    public static final RecipeModifier PARALLEL_HATCH = GTRecipeModifiers::hatchParallel;

    @NotNull
    public static ModifierFunction hatchParallel(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        IMultiController controller;
        if (machine instanceof IMultiController && (controller = (IMultiController)((Object)machine)).isFormed()) {
            int parallels = controller.getParts().stream().filter(IParallelHatch.class::isInstance).map(IParallelHatch.class::cast).findAny().map(hatch -> ParallelLogic.getParallelAmount(machine, recipe, hatch.getCurrentParallel())).orElse(1);
            if (parallels == 1) {
                return ModifierFunction.IDENTITY;
            }
            return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier(parallels)).eutMultiplier(parallels).parallels(parallels).build();
        }
        return ModifierFunction.IDENTITY;
    }

    @NotNull
    public static ModifierFunction crackerOverclock(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof CoilWorkableElectricMultiblockMachine)) {
            return RecipeModifier.nullWrongType(CoilWorkableElectricMultiblockMachine.class, machine);
        }
        CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
        if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
            return ModifierFunction.NULL;
        }
        ModifierFunction oc = OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK.getModifier(machine, recipe, coilMachine.getOverclockVoltage());
        if (coilMachine.getCoilTier() > 0) {
            ModifierFunction coilModifier = ModifierFunction.builder().eutMultiplier(1.0 - (double)coilMachine.getCoilTier() * 0.1).build();
            oc = oc.andThen(coilModifier);
        }
        return oc;
    }

    @NotNull
    public static ModifierFunction ebfOverclock(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof CoilWorkableElectricMultiblockMachine)) {
            return RecipeModifier.nullWrongType(CoilWorkableElectricMultiblockMachine.class, machine);
        }
        CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
        int blastFurnaceTemperature = coilMachine.getCoilType().getCoilTemperature() + 100 * Math.max(0, coilMachine.getTier() - 2);
        int recipeTemp = recipe.data.m_128451_("ebf_temp");
        if (!recipe.data.m_128441_("ebf_temp") || recipeTemp > blastFurnaceTemperature) {
            return ModifierFunction.NULL;
        }
        if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
            return ModifierFunction.NULL;
        }
        ModifierFunction discount = ModifierFunction.builder().eutMultiplier(OverclockingLogic.getCoilEUtDiscount(recipeTemp, blastFurnaceTemperature)).build();
        OverclockingLogic logic = (p, v) -> OverclockingLogic.heatingCoilOC(p, v, recipeTemp, blastFurnaceTemperature);
        ModifierFunction oc = logic.getModifier(machine, recipe, coilMachine.getOverclockVoltage());
        return oc.compose(discount);
    }

    @NotNull
    public static ModifierFunction pyrolyseOvenOverclock(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof CoilWorkableElectricMultiblockMachine)) {
            return RecipeModifier.nullWrongType(CoilWorkableElectricMultiblockMachine.class, machine);
        }
        CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
        if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
            return ModifierFunction.NULL;
        }
        int tier = coilMachine.getCoilTier();
        double durationMultiplier = tier == 0 ? 1.3333333333333333 : 2.0 / (double)(tier + 1);
        ModifierFunction durationModifier = ModifierFunction.builder().durationMultiplier(durationMultiplier).build();
        ModifierFunction oc = OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK.getModifier(machine, recipe, coilMachine.getOverclockVoltage());
        return oc.andThen(durationModifier);
    }

    @NotNull
    public static ModifierFunction multiSmelterParallel(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof CoilWorkableElectricMultiblockMachine)) {
            return RecipeModifier.nullWrongType(CoilWorkableElectricMultiblockMachine.class, machine);
        }
        CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
        int maxParallel = 32 * coilMachine.getCoilType().getLevel();
        int parallels = ParallelLogic.getParallelAmount(machine, recipe, maxParallel);
        if (parallels == 0) {
            return ModifierFunction.NULL;
        }
        int duration = (int)(256.0 * (double)parallels / (double)maxParallel);
        long eut = 4L * (long)((double)parallels / (8.0 * (double)coilMachine.getCoilType().getEnergyDiscount()));
        ModifierFunction baseModifier = r -> {
            GTRecipe copy = r.copy();
            EURecipeCapability.putEUContent(copy.tickInputs, Math.max(1L, eut));
            copy.duration = Math.max(1, duration);
            return copy;
        };
        GTRecipe copy = baseModifier.apply(recipe);
        ModifierFunction ocModifier = OverclockingLogic.NON_PERFECT_OVERCLOCK.getModifier(machine, copy, coilMachine.getOverclockVoltage());
        ModifierFunction parallelModifier = ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier(parallels)).parallels(parallels).build();
        return baseModifier.andThen(ocModifier).andThen(parallelModifier);
    }
}

