/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.block.IFusionCasingType;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.common.block.BatteryBlock;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import com.gregtechceu.gtceu.common.block.FusionCasingBlock;
import com.gregtechceu.gtceu.common.block.LampBlock;
import com.gregtechceu.gtceu.core.MixinHelpers;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class GTModels {
    public static void createModelBlockState(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, ResourceLocation modelLocation) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(modelLocation));
    }

    public static void createCrossBlockState(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)ctx.getEntry())).m_135815_(), prov.blockTexture((Block)ctx.getEntry())));
    }

    public static void cellModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov) {
        ((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/" + prov.name(() -> ctx.getEntry()) + "_empty")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", prov.modLoc("item/%s/base".formatted(prov.name(ctx))));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/" + prov.name(() -> ctx.getEntry()) + "_filled")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", prov.modLoc("item/%s/base".formatted(prov.name(ctx))))).texture("layer1", prov.modLoc("item/%s/overlay".formatted(prov.name(ctx))));
        prov.generated(() -> ctx.getEntry(), new ResourceLocation[]{prov.modLoc("item/%s/base".formatted(prov.name(ctx)))}).override().predicate(GTCEu.id("fluid_cell"), 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(prov.modLoc("item/%s_empty".formatted(prov.name(ctx))))).end().override().predicate(GTCEu.id("fluid_cell"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(prov.modLoc("item/%s_filled".formatted(prov.name(ctx))))).end();
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> overrideModel(ResourceLocation predicate, int modelNumber) {
        if (modelNumber <= 0) {
            return NonNullBiConsumer.noop();
        }
        return (ctx, prov) -> {
            ItemModelBuilder rootModel = prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{prov.modLoc("item/%s/1".formatted(prov.name((NonNullSupplier)ctx)))});
            for (int i = 0; i < modelNumber; ++i) {
                ItemModelBuilder subModelBuilder = (ItemModelBuilder)((ItemModelBuilder)prov.getBuilder("item/" + prov.name(() -> ((DataGenContext)ctx).getEntry()) + "/" + i)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
                subModelBuilder.texture("layer0", prov.modLoc("item/%s/%d".formatted(prov.name((NonNullSupplier)ctx), i + 1)));
                rootModel = rootModel.override().predicate(predicate, (float)i / 100.0f).model((ModelFile)new ModelFile.UncheckedModelFile(prov.modLoc("item/%s/%d".formatted(prov.name((NonNullSupplier)ctx), i)))).end();
            }
        };
    }

    public static void createTextureModel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, ResourceLocation texture) {
        prov.generated(ctx, new ResourceLocation[]{texture});
    }

    public static void rubberTreeSaplingModel(DataGenContext<Item, BlockItem> context, RegistrateItemModelProvider provider) {
        provider.generated(context, new ResourceLocation[]{provider.modLoc("block/" + provider.name(context))});
    }

    public static void longDistanceItemPipeModel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll("long_distance_item_pipeline", prov.modLoc("block/pipe/ld_item_pipe/block")));
    }

    public static void longDistanceFluidPipeModel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll("long_distance_fluid_pipeline", prov.modLoc("block/pipe/ld_fluid_pipe/block")));
    }

    public static NonNullBiConsumer<DataGenContext<Block, LampBlock>, RegistrateBlockstateProvider> lampModel(DyeColor color, boolean border) {
        return (ctx, prov) -> {
            String borderPart = border ? "" : "_borderless";
            ModelFile.ExistingModelFile parentOn = prov.models().getExistingFile(prov.modLoc("block/lamp" + borderPart));
            ModelFile.ExistingModelFile parentOff = prov.models().getExistingFile(prov.modLoc("block/lamp" + borderPart + "_off"));
            prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> GTModels.lambda$lampModel$1(prov, ctx, (ModelFile)parentOn, border, color, (ModelFile)parentOff, borderPart, arg_0));
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateBlockstateProvider> randomRotatedModel(ResourceLocation texturePath) {
        return (ctx, prov) -> {
            Block block = (Block)ctx.getEntry();
            ModelBuilder cubeAll = prov.models().cubeAll(ctx.getName(), texturePath);
            ModelBuilder cubeMirroredAll = prov.models().singleTexture(ctx.getName() + "_mirrored", prov.mcLoc("block/cube_mirrored_all"), "all", texturePath);
            ConfiguredModel[] models = ConfiguredModel.builder().modelFile((ModelFile)cubeAll).rotationY(0).nextModel().modelFile((ModelFile)cubeAll).rotationY(180).nextModel().modelFile((ModelFile)cubeMirroredAll).rotationY(0).nextModel().modelFile((ModelFile)cubeMirroredAll).rotationY(180).build();
            prov.simpleBlock(block, models);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateBlockstateProvider> createSidedCasingModel(String name, ResourceLocation texture) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeBottomTop(name, texture.m_266382_("/side"), texture.m_266382_("/bottom"), texture.m_266382_("/top")));
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateBlockstateProvider> cubeAllModel(String name, ResourceLocation texture) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll(name, texture));
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateBlockstateProvider> createMachineCasingModel(String tierName) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("%s_machine_casing".formatted(tierName), GTCEu.id("block/cube/tinted/bottom_top"))).texture("bottom", GTCEu.id("block/casings/voltage/%s/bottom".formatted(tierName)))).texture("top", GTCEu.id("block/casings/voltage/%s/top".formatted(tierName)))).texture("side", GTCEu.id("block/casings/voltage/%s/side".formatted(tierName))));
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateBlockstateProvider> createHermeticCasingModel(String tierName) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("%s_hermetic_casing".formatted(tierName), GTCEu.id("block/hermetic_casing"))).texture("bot_bottom", GTCEu.id("block/casings/voltage/%s/bottom".formatted(tierName)))).texture("bot_top", GTCEu.id("block/casings/voltage/%s/top".formatted(tierName)))).texture("bot_side", GTCEu.id("block/casings/voltage/%s/side".formatted(tierName)))).texture("top_side", GTCEu.id("block/casings/hermetic_casing/hermetic_casing_overlay")));
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateBlockstateProvider> createSteamCasingModel(String name, String material) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeBottomTop(name, GTCEu.id("block/casings/steam/%s/side".formatted(material)), GTCEu.id("block/casings/steam/%s/bottom".formatted(material)), GTCEu.id("block/casings/steam/%s/top".formatted(material))));
    }

    public static NonNullBiConsumer<DataGenContext<Block, CoilBlock>, RegistrateBlockstateProvider> createCoilModel(String name, ICoilType coilType) {
        return (ctx, prov) -> {
            ActiveBlock block = (ActiveBlock)ctx.getEntry();
            ModelBuilder inactive = prov.models().cubeAll(name, coilType.getTexture());
            ModelBuilder active = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_active", GTCEu.id("block/cube_2_layer/all"))).texture("bot_all", coilType.getTexture())).texture("top_all", coilType.getTexture().m_266382_("_bloom"));
            ((VariantBlockStateBuilder)prov.getVariantBuilder((Block)block).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)inactive).addModel()).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)active).addModel();
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, BatteryBlock>, RegistrateBlockstateProvider> createBatteryBlockModel(String name, IBatteryData batteryData) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeBottomTop(name, GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/side"), GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/top"), GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/top")));
    }

    public static NonNullBiConsumer<DataGenContext<Block, FusionCasingBlock>, RegistrateBlockstateProvider> createFusionCasingModel(String name, IFusionCasingType casingType) {
        return (ctx, prov) -> {
            ActiveBlock block = (ActiveBlock)ctx.getEntry();
            ModelBuilder inactive = prov.models().cubeAll(name, casingType.getTexture());
            ModelBuilder active = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_active", GTCEu.id("block/cube_2_layer/all"))).texture("bot_all", casingType.getTexture())).texture("top_all", new ResourceLocation(casingType.getTexture() + "_bloom"));
            ((VariantBlockStateBuilder)prov.getVariantBuilder((Block)block).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)inactive).addModel()).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)active).addModel();
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateBlockstateProvider> createCleanroomFilterModel(String name, IFilterType type) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll(name, GTCEu.id("block/casings/cleanroom/" + type)));
    }

    public static NonNullBiConsumer<DataGenContext<Block, ActiveBlock>, RegistrateBlockstateProvider> createActiveModel(ResourceLocation modelPath) {
        return (ctx, prov) -> {
            ActiveBlock block = (ActiveBlock)ctx.getEntry();
            ModelFile.ExistingModelFile inactive = prov.models().getExistingFile(modelPath);
            ModelFile.ExistingModelFile active = prov.models().getExistingFile(modelPath.m_266382_("_active"));
            ((VariantBlockStateBuilder)prov.getVariantBuilder((Block)block).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)inactive).addModel()).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)active).addModel();
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, ActiveBlock>, RegistrateBlockstateProvider> createFireboxModel(String name, BoilerFireboxType type) {
        return (ctx, prov) -> {
            ActiveBlock block = (ActiveBlock)ctx.getEntry();
            ModelBuilder inactive = prov.models().cubeBottomTop(name, type.side(), type.bottom(), type.top());
            ModelBuilder active = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_active", GTCEu.id("block/fire_box_active"))).texture("side", type.side())).texture("bottom", type.bottom())).texture("top", type.top());
            ((VariantBlockStateBuilder)prov.getVariantBuilder((Block)block).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)inactive).addModel()).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)active).addModel();
        };
    }

    public static void registerMaterialFluidModels() {
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            FluidProperty fluidProperty = material.getProperty(PropertyKey.FLUID);
            if (fluidProperty == null) continue;
            MaterialIconSet iconSet = material.getMaterialIconSet();
            for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                JsonObject original;
                Fluid fluid;
                FluidStorage storage = fluidProperty.getStorage();
                FluidStorage.FluidEntry fluidEntry = storage.getEntry(key);
                if (fluidEntry != null && fluidEntry.getBuilder() != null) {
                    if (fluidEntry.getBuilder().still() == null) {
                        ResourceLocation foundTexture = key.getIconType().getBlockTexturePath(iconSet, false);
                        fluidEntry.getBuilder().still(foundTexture);
                    }
                    if (fluidEntry.getBuilder().flowing() == null) {
                        fluidEntry.getBuilder().flowing(fluidEntry.getBuilder().still());
                    }
                    MixinHelpers.addFluidTexture(material, fluidEntry);
                }
                if (!((fluid = storage.get(key)) instanceof GTFluid)) continue;
                GTFluid gtFluid = (GTFluid)fluid;
                try (BufferedReader reader = Minecraft.m_91087_().m_91098_().m_215597_(GTCEu.id("models/item/bucket/bucket.json"));){
                    original = GsonHelper.m_13861_((Reader)reader, (boolean)true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                JsonObject newJson = original.deepCopy();
                newJson.addProperty("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)gtFluid).toString());
                if (gtFluid.getFluidType().isLighterThanAir()) {
                    newJson.addProperty("flip_gas", Boolean.valueOf(true));
                }
                if (gtFluid.getFluidType().getLightLevel() > 0) {
                    newJson.addProperty("apply_fluid_luminosity", Boolean.valueOf(true));
                }
                GTDynamicResourcePack.addItemModel(BuiltInRegistries.f_257033_.m_7981_((Object)gtFluid.m_6859_()), (JsonElement)newJson);
            }
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$lampModel$1(RegistrateBlockstateProvider prov, DataGenContext ctx, ModelFile parentOn, boolean border, DyeColor color, ModelFile parentOff, String borderPart, BlockState state) {
        if (((Boolean)state.m_61143_((Property)LampBlock.LIGHT)).booleanValue()) {
            ModelBuilder model = ((BlockModelBuilder)prov.models().getBuilder(ctx.getName() + ((Boolean)state.m_61143_((Property)LampBlock.BLOOM) != false ? "_bloom" : ""))).parent(parentOn);
            if (border) {
                model.texture("active", "block/lamps/" + color.m_41065_());
                if (((Boolean)state.m_61143_((Property)LampBlock.BLOOM)).booleanValue()) {
                    model.texture("active_overlay", "block/lamps/" + color.m_41065_() + "_emissive");
                } else {
                    model.texture("active_overlay", "block/lamps/" + color.m_41065_());
                }
            } else if (((Boolean)state.m_61143_((Property)LampBlock.BLOOM)).booleanValue()) {
                model.texture("active", "block/lamps/" + color.m_41065_() + "_borderless_emissive");
            } else {
                model.texture("active", "block/lamps/" + color.m_41065_() + "_borderless");
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }
        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder(ctx.getName() + "_off")).parent(parentOff)).texture("inactive", "block/lamps/" + color.m_41065_() + "_off" + borderPart)).build();
    }
}

