/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.transfer.item.ItemHandlerDelegate;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.data.DistributionMode;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConveyorCover
extends CoverBehavior
implements IUICover,
IControllable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ConveyorCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    public static final Int2IntFunction CONVEYOR_SCALING = tier -> 2 * (int)Math.pow(4.0, Math.min(tier, 6));
    public final int tier;
    public final int maxItemTransferRate;
    @Persisted
    protected int transferRate;
    @Persisted
    @DescSynced
    @RequireRerender
    protected IO io;
    @Persisted
    @DescSynced
    protected DistributionMode distributionMode;
    @Persisted
    @DescSynced
    protected ManualIOMode manualIOMode = ManualIOMode.DISABLED;
    @Persisted
    protected boolean isWorkingEnabled = true;
    protected int itemsLeftToTransferLastSecond;
    private Widget ioModeSwitch;
    @Persisted
    @DescSynced
    protected final FilterHandler<ItemStack, ItemFilter> filterHandler;
    protected final ConditionalSubscriptionHandler subscriptionHandler;
    private CoverableItemHandlerWrapper itemHandlerWrapper;

    public ConveyorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier, int maxTransferRate) {
        super(definition, coverHolder, attachedSide);
        this.tier = tier;
        this.itemsLeftToTransferLastSecond = this.transferRate = (this.maxItemTransferRate = maxTransferRate);
        this.io = IO.OUT;
        this.distributionMode = DistributionMode.INSERT_FIRST;
        this.subscriptionHandler = new ConditionalSubscriptionHandler(coverHolder, this::update, this::isSubscriptionActive);
        this.filterHandler = FilterHandlers.item(this).onFilterLoaded(f -> this.configureFilter()).onFilterUpdated(f -> this.configureFilter()).onFilterRemoved(f -> this.configureFilter());
    }

    public ConveyorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        this(definition, coverHolder, attachedSide, tier, CONVEYOR_SCALING.applyAsInt(tier));
    }

    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled() && this.getAdjacentItemHandler() != null;
    }

    @Nullable
    protected IItemHandlerModifiable getOwnItemHandler() {
        return this.coverHolder.getItemHandlerCap(this.attachedSide, false);
    }

    @Nullable
    protected IItemHandler getAdjacentItemHandler() {
        return GTTransferUtils.getAdjacentItemHandler(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide).resolve().orElse(null);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean canAttach() {
        return this.getOwnItemHandler() != null;
    }

    public void setTransferRate(int transferRate) {
        if (transferRate <= this.maxItemTransferRate) {
            this.transferRate = transferRate;
        }
    }

    public void setIo(IO io) {
        if (io == IO.IN || io == IO.OUT) {
            this.io = io;
        }
        this.subscriptionHandler.updateSubscription();
        this.coverHolder.markDirty();
    }

    public void setDistributionMode(DistributionMode distributionMode) {
        this.distributionMode = distributionMode;
        this.coverHolder.markDirty();
    }

    protected void setManualIOMode(ManualIOMode manualIOMode) {
        this.manualIOMode = manualIOMode;
        this.coverHolder.markDirty();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscriptionHandler.initialize(this.coverHolder.getLevel());
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.subscriptionHandler.unsubscribe();
    }

    @Override
    public List<ItemStack> getAdditionalDrops() {
        List<ItemStack> list = super.getAdditionalDrops();
        if (!this.filterHandler.getFilterItem().m_41619_()) {
            list.add(this.filterHandler.getFilterItem());
        }
        return list;
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        this.subscriptionHandler.updateSubscription();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.isWorkingEnabled != isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
            this.subscriptionHandler.updateSubscription();
        }
    }

    protected void update() {
        long timer = this.coverHolder.getOffsetTimer();
        if (timer % 5L == 0L) {
            if (this.itemsLeftToTransferLastSecond > 0) {
                IItemHandler adjacent = this.getAdjacentItemHandler();
                IItemHandlerModifiable self = this.getOwnItemHandler();
                if (adjacent != null && self != null) {
                    int totalTransferred = switch (this.io) {
                        case IO.IN -> this.doTransferItems(adjacent, (IItemHandler)self, this.itemsLeftToTransferLastSecond);
                        case IO.OUT -> this.doTransferItems((IItemHandler)self, adjacent, this.itemsLeftToTransferLastSecond);
                        default -> 0;
                    };
                    this.itemsLeftToTransferLastSecond -= totalTransferred;
                }
            }
            if (timer % 20L == 0L) {
                this.itemsLeftToTransferLastSecond = this.transferRate;
            }
            this.subscriptionHandler.updateSubscription();
        }
    }

    protected int doTransferItems(IItemHandler sourceInventory, IItemHandler targetInventory, int maxTransferAmount) {
        return this.moveInventoryItems(sourceInventory, targetInventory, maxTransferAmount);
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, int maxTransferAmount) {
        ItemFilter filter = this.filterHandler.getFilter();
        int itemsLeftToTransfer = maxTransferAmount;
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, itemsLeftToTransfer, true);
            if (sourceStack.m_41619_() || !filter.test(sourceStack)) continue;
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)true);
            int amountToInsert = sourceStack.m_41613_() - remainder.m_41613_();
            if (amountToInsert <= 0 || (sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false)).m_41619_()) continue;
            ItemHandlerHelper.insertItem((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)false);
            if ((itemsLeftToTransfer -= sourceStack.m_41613_()) == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    protected static boolean moveInventoryItemsExact(IItemHandler sourceInventory, IItemHandler targetInventory, TypeItemInfo itemInfo) {
        ItemStack resultStack = itemInfo.itemStack.m_41777_();
        int totalExtractedCount = 0;
        int itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = itemInfo.slots.getInt(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, true);
            if (!extractedStack.m_41619_() && ItemStack.m_150942_((ItemStack)resultStack, (ItemStack)extractedStack)) {
                totalExtractedCount += extractedStack.m_41613_();
                itemsLeftToExtract -= extractedStack.m_41613_();
            }
            if (itemsLeftToExtract == 0) break;
        }
        if (totalExtractedCount != itemInfo.totalCount) {
            return false;
        }
        resultStack.m_41764_(totalExtractedCount);
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)targetInventory, (ItemStack)resultStack, (boolean)true);
        if (!remainder.m_41619_()) {
            return false;
        }
        ItemHandlerHelper.insertItem((IItemHandler)targetInventory, (ItemStack)resultStack, (boolean)false);
        itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = itemInfo.slots.getInt(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, false);
            if (!extractedStack.m_41619_() && ItemStack.m_150942_((ItemStack)resultStack, (ItemStack)extractedStack)) {
                itemsLeftToExtract -= extractedStack.m_41613_();
            }
            if (itemsLeftToExtract == 0) break;
        }
        return true;
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, Map<ItemStack, GroupItemInfo> itemInfos, int maxTransferAmount) {
        ItemFilter filter = this.filterHandler.getFilter();
        int itemsLeftToTransfer = maxTransferAmount;
        for (int i = 0; i < sourceInventory.getSlots(); ++i) {
            ItemStack itemStack = sourceInventory.getStackInSlot(i);
            if (itemStack.m_41619_() || !filter.test(itemStack) || !itemInfos.containsKey(itemStack)) continue;
            GroupItemInfo itemInfo = itemInfos.get(itemStack);
            ItemStack extractedStack = sourceInventory.extractItem(i, Math.min(itemInfo.totalCount, itemsLeftToTransfer), true);
            ItemStack remainderStack = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extractedStack, (boolean)true);
            int amountToInsert = extractedStack.m_41613_() - remainderStack.m_41613_();
            if (amountToInsert <= 0 || (extractedStack = sourceInventory.extractItem(i, amountToInsert, false)).m_41619_()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extractedStack, (boolean)false);
            itemsLeftToTransfer -= extractedStack.m_41613_();
            itemInfo.totalCount -= extractedStack.m_41613_();
            if (itemInfo.totalCount == 0) {
                itemInfos.remove(itemStack);
                if (itemInfos.isEmpty()) break;
            }
            if (itemsLeftToTransfer == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    @NotNull
    protected Map<ItemStack, TypeItemInfo> countInventoryItemsByType(@NotNull IItemHandler inventory) {
        ItemFilter filter = this.filterHandler.getFilter();
        Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.m_41619_() || !filter.test(itemStack)) continue;
            TypeItemInfo itemInfo = result.computeIfAbsent(itemStack, s -> new TypeItemInfo((ItemStack)s, (IntList)new IntArrayList(), 0));
            itemInfo.totalCount += itemStack.m_41613_();
            itemInfo.slots.add(srcIndex);
        }
        return result;
    }

    @NotNull
    protected Map<ItemStack, GroupItemInfo> countInventoryItemsByMatchSlot(@NotNull IItemHandler inventory) {
        ItemFilter filter = this.filterHandler.getFilter();
        Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.m_41619_() || !filter.test(itemStack)) continue;
            GroupItemInfo itemInfo = result.computeIfAbsent(itemStack, s -> new GroupItemInfo((ItemStack)s, 0));
            itemInfo.totalCount += itemStack.m_41613_();
        }
        return result;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 137);
        group.addWidget((Widget)new LabelWidget(10, 5, Component.m_237110_((String)this.getUITitle(), (Object[])new Object[]{GTValues.VN[this.tier]}).getString()));
        group.addWidget(new IntInputWidget(10, 20, 156, 20, () -> this.transferRate, this::setTransferRate).setMin(1).setMax(this.maxItemTransferRate));
        this.ioModeSwitch = new SwitchWidget(10, 45, 20, 20, (clickData, value) -> {
            this.setIo(value != false ? IO.IN : IO.OUT);
            this.ioModeSwitch.setHoverTooltips(new String[]{LocalizationUtils.format((String)"cover.conveyor.mode", (Object[])new Object[]{LocalizationUtils.format((String)this.io.tooltip, (Object[])new Object[0])})});
        }).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, IO.OUT.icon}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, IO.IN.icon})).setPressed(this.io == IO.IN).setHoverTooltips(new String[]{LocalizationUtils.format((String)"cover.conveyor.mode", (Object[])new Object[]{LocalizationUtils.format((String)this.io.tooltip, (Object[])new Object[0])})});
        group.addWidget(this.ioModeSwitch);
        if (this.shouldDisplayDistributionMode()) {
            group.addWidget((Widget)new EnumSelectorWidget(146, 67, 20, 20, (Enum[])DistributionMode.VALUES, (Enum)this.distributionMode, this::setDistributionMode));
        }
        group.addWidget(new EnumSelectorWidget(146, 107, 20, 20, (Enum[])ManualIOMode.VALUES, (Enum)this.manualIOMode, this::setManualIOMode).setHoverTooltips(new String[]{"cover.universal.manual_import_export.mode.description"}));
        group.addWidget(this.filterHandler.createFilterSlotUI(125, 108));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 72, 156, 60));
        this.buildAdditionalUI(group);
        return group;
    }

    private boolean shouldDisplayDistributionMode() {
        return this.coverHolder.getLevel().m_7702_(this.coverHolder.getPos()) instanceof ItemPipeBlockEntity || this.coverHolder.getLevel().m_7702_(this.coverHolder.getPos().m_121945_(this.attachedSide)) instanceof ItemPipeBlockEntity;
    }

    @NotNull
    protected String getUITitle() {
        return "cover.conveyor.title";
    }

    protected void buildAdditionalUI(WidgetGroup group) {
    }

    protected void configureFilter() {
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable IItemHandlerModifiable defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (this.itemHandlerWrapper == null || this.itemHandlerWrapper.delegate != defaultValue) {
            this.itemHandlerWrapper = new CoverableItemHandlerWrapper(defaultValue);
        }
        return this.itemHandlerWrapper;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public IO getIo() {
        return this.io;
    }

    public DistributionMode getDistributionMode() {
        return this.distributionMode;
    }

    public ManualIOMode getManualIOMode() {
        return this.manualIOMode;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public FilterHandler<ItemStack, ItemFilter> getFilterHandler() {
        return this.filterHandler;
    }

    protected static class TypeItemInfo {
        public final ItemStack itemStack;
        public final IntList slots;
        public int totalCount;

        public TypeItemInfo(ItemStack itemStack, IntList slots, int totalCount) {
            this.itemStack = itemStack;
            this.slots = slots;
            this.totalCount = totalCount;
        }
    }

    protected static class GroupItemInfo {
        public final ItemStack itemStack;
        public int totalCount;

        public GroupItemInfo(ItemStack itemStack, int totalCount) {
            this.itemStack = itemStack;
            this.totalCount = totalCount;
        }
    }

    private class CoverableItemHandlerWrapper
    extends ItemHandlerDelegate {
        public CoverableItemHandlerWrapper(IItemHandlerModifiable delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (ConveyorCover.this.io == IO.OUT && ConveyorCover.this.manualIOMode == ManualIOMode.DISABLED) {
                return stack;
            }
            if (ConveyorCover.this.manualIOMode == ManualIOMode.FILTERED && !ConveyorCover.this.filterHandler.test(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (ConveyorCover.this.io == IO.IN && ConveyorCover.this.manualIOMode == ManualIOMode.DISABLED) {
                return ItemStack.f_41583_;
            }
            if (ConveyorCover.this.manualIOMode == ManualIOMode.FILTERED) {
                ItemStack result = super.extractItem(slot, amount, true);
                if (result.m_41619_() || !ConveyorCover.this.filterHandler.test(result)) {
                    return ItemStack.f_41583_;
                }
                return simulate ? result : super.extractItem(slot, amount, false);
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

