/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    private static final Map<Direction, Vector3f[]> DIRECTION_POSITION_MAP = new HashMap<Direction, Vector3f[]>(){
        {
            this.put(Direction.UP, new Vector3f[]{RenderUtil.vec3f(0.0f, 1.0f, 1.0f), RenderUtil.vec3f(1.0f, 1.0f, 1.0f), RenderUtil.vec3f(1.0f, 1.0f, 0.0f), RenderUtil.vec3f(0.0f, 1.0f, 0.0f)});
            this.put(Direction.DOWN, new Vector3f[]{RenderUtil.vec3f(1.0f, 0.0f, 1.0f), RenderUtil.vec3f(0.0f, 0.0f, 1.0f), RenderUtil.vec3f(0.0f, 0.0f, 0.0f), RenderUtil.vec3f(1.0f, 0.0f, 0.0f)});
            this.put(Direction.SOUTH, new Vector3f[]{RenderUtil.vec3f(1.0f, 1.0f, 0.0f), RenderUtil.vec3f(1.0f, 0.0f, 0.0f), RenderUtil.vec3f(0.0f, 0.0f, 0.0f), RenderUtil.vec3f(0.0f, 1.0f, 0.0f)});
            this.put(Direction.NORTH, new Vector3f[]{RenderUtil.vec3f(0.0f, 1.0f, 1.0f), RenderUtil.vec3f(0.0f, 0.0f, 1.0f), RenderUtil.vec3f(1.0f, 0.0f, 1.0f), RenderUtil.vec3f(1.0f, 1.0f, 1.0f)});
            this.put(Direction.EAST, new Vector3f[]{RenderUtil.vec3f(0.0f, 1.0f, 0.0f), RenderUtil.vec3f(0.0f, 0.0f, 0.0f), RenderUtil.vec3f(0.0f, 0.0f, 1.0f), RenderUtil.vec3f(0.0f, 1.0f, 1.0f)});
            this.put(Direction.WEST, new Vector3f[]{RenderUtil.vec3f(1.0f, 1.0f, 1.0f), RenderUtil.vec3f(1.0f, 0.0f, 1.0f), RenderUtil.vec3f(1.0f, 0.0f, 0.0f), RenderUtil.vec3f(1.0f, 1.0f, 0.0f)});
        }
    };
    private static final Map<Direction, Vector3f> DIRECTION_NORMAL_MAP = new HashMap<Direction, Vector3f>(){
        {
            this.put(Direction.UP, RenderUtil.vec3f(0.0f, 1.0f, 0.0f));
            this.put(Direction.DOWN, RenderUtil.vec3f(0.0f, 1.0f, 0.0f));
            this.put(Direction.SOUTH, RenderUtil.vec3f(0.0f, 0.0f, 1.0f));
            this.put(Direction.NORTH, RenderUtil.vec3f(0.0f, 0.0f, 1.0f));
            this.put(Direction.EAST, RenderUtil.vec3f(1.0f, 0.0f, 0.0f));
            this.put(Direction.WEST, RenderUtil.vec3f(1.0f, 0.0f, 0.0f));
        }
    };

    public static Vec3 vec3(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    public static Vector3f vec3f(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }

    public static Vector3f[] getVertices(Direction direction) {
        return DIRECTION_POSITION_MAP.get(direction);
    }

    public static Vector3f getNormal(Direction direction) {
        return DIRECTION_NORMAL_MAP.get(direction);
    }

    public static int getFluidLight(Fluid fluid, BlockPos pos) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return 0;
        }
        return LevelRenderer.m_109537_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockState)fluid.m_76145_().m_76188_(), (BlockPos)pos);
    }

    public static void vertex(Matrix4f pose, VertexConsumer vertexConsumer, float x, float y, float z, int r, int g, int b, int a, float u, float v, int overlayCoords, int lightOverlay, float v0, float v1, float v2) {
        vertexConsumer.m_252986_(pose, x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(overlayCoords).m_85969_(lightOverlay).m_5601_(v0, v1, v2).m_5752_();
    }

    public static Vector3f transformVertex(Vector3f vertex, Direction direction, float offsetX, float offsetY, float offsetZ) {
        float addX = offsetX;
        float addY = offsetY;
        float addZ = offsetZ;
        switch (direction) {
            case DOWN: {
                addY = -addY;
                break;
            }
            case SOUTH: {
                addZ = -addZ;
                break;
            }
            case EAST: {
                addX = -addX;
            }
        }
        return RenderUtil.vec3f(vertex.x + addX, vertex.y + addY, vertex.z + addZ);
    }

    public static Fluid getRecipeFluidToRender(GTRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        ObjectArrayList contents = new ObjectArrayList();
        ArrayList empty = new ArrayList();
        contents.addAll((Collection)recipe.outputs.getOrDefault(FluidRecipeCapability.CAP, empty));
        contents.addAll((Collection)recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, empty));
        if (contents.isEmpty()) {
            return null;
        }
        Optional<Content> fluidContent = contents.stream().filter(content -> {
            FluidIngredient ingredient;
            Object patt5812$temp = content.content;
            return patt5812$temp instanceof FluidIngredient && !(ingredient = (FluidIngredient)patt5812$temp).isEmpty();
        }).findAny();
        if (fluidContent.isEmpty()) {
            return null;
        }
        FluidIngredient ingredient = (FluidIngredient)fluidContent.get().content;
        FluidStack[] stacks = ingredient.getStacks();
        if (stacks.length == 0) {
            return null;
        }
        Fluid fluid = null;
        for (int i = 0; i < stacks.length && fluid == null; ++i) {
            if (stacks[i].isEmpty()) continue;
            fluid = stacks[i].getFluid();
        }
        return fluid;
    }

    public static enum FluidTextureType {
        STILL(fluidTypeExtensions -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getStillTexture())),
        FLOWING(fluidTypeExtensions -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getFlowingTexture())),
        OVERLAY(fluidTypeExtensions -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getOverlayTexture()));

        private final Function<IClientFluidTypeExtensions, TextureAtlasSprite> mapper;

        private FluidTextureType(Function<IClientFluidTypeExtensions, TextureAtlasSprite> mapper) {
            this.mapper = mapper;
        }

        public TextureAtlasSprite map(IClientFluidTypeExtensions fluidTypeExtensions) {
            return this.mapper.apply(fluidTypeExtensions);
        }
    }
}

