/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderBufferHelper {
    public static void renderRing(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float r, float tubeRadius, int sides, int segments, float red, float green, float blue, float alpha, Direction.Axis axis) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float sideDelta = (float)(Math.PI * 2 / (double)sides);
        float ringDelta = (float)(Math.PI * 2 / (double)segments);
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        for (int i = 0; i < segments; ++i) {
            float theta1 = theta + ringDelta;
            float cosTheta1 = Mth.m_14089_((float)theta1);
            float sinTheta1 = Mth.m_14031_((float)theta1);
            float phi = 0.0f;
            block6: for (int j = 0; j <= sides; ++j) {
                float cosPhi = Mth.m_14089_((float)(phi += sideDelta));
                float sinPhi = Mth.m_14031_((float)phi);
                float dist = r + tubeRadius * cosPhi;
                switch (axis) {
                    case Y: {
                        buffer.m_252986_(mat, x + sinTheta * dist, y + tubeRadius * sinPhi, z + cosTheta * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        buffer.m_252986_(mat, x + sinTheta1 * dist, y + tubeRadius * sinPhi, z + cosTheta1 * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        continue block6;
                    }
                    case X: {
                        buffer.m_252986_(mat, x + tubeRadius * sinPhi, y + sinTheta * dist, z + cosTheta * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        buffer.m_252986_(mat, x + tubeRadius * sinPhi, y + sinTheta1 * dist, z + cosTheta1 * dist).m_85950_(red, green, blue, alpha).m_5752_();
                        continue block6;
                    }
                    case Z: {
                        buffer.m_252986_(mat, x + cosTheta * dist, y + sinTheta * dist, z + tubeRadius * sinPhi).m_85950_(red, green, blue, alpha).m_5752_();
                        buffer.m_252986_(mat, x + cosTheta1 * dist, y + sinTheta1 * dist, z + tubeRadius * sinPhi).m_85950_(red, green, blue, alpha).m_5752_();
                    }
                }
            }
            theta = theta1;
            cosTheta = cosTheta1;
            sinTheta = sinTheta1;
        }
    }
}

