/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.item;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.common.block.LampBlock;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LampItemOverlayRenderer {
    private LampItemOverlayRenderer() {
    }

    public static OverlayType getOverlayType(boolean light, boolean bloom) {
        if (light) {
            return bloom ? OverlayType.NONE : OverlayType.NO_BLOOM;
        }
        return bloom ? OverlayType.NO_LIGHT : OverlayType.NO_BLOOM_NO_LIGHT;
    }

    public static void renderOverlay(GuiGraphics graphics, ItemStack stack, int xPosition, int yPosition) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            OverlayType overlayType = LampItemOverlayRenderer.getOverlayType(LampBlock.isLightEnabled(tag), LampBlock.isBloomEnabled(tag));
            if (overlayType == OverlayType.NONE) {
                return;
            }
            RenderSystem.disableDepthTest();
            if (overlayType.noBloom()) {
                GuiTextures.LAMP_NO_BLOOM.draw(graphics, 0, 0, (float)xPosition, (float)yPosition, 16, 16);
            }
            if (overlayType.noLight()) {
                GuiTextures.LAMP_NO_LIGHT.draw(graphics, 0, 0, (float)xPosition, (float)yPosition, 16, 16);
            }
            RenderSystem.enableDepthTest();
        }
    }

    public static enum OverlayType {
        NONE,
        NO_BLOOM,
        NO_LIGHT,
        NO_BLOOM_NO_LIGHT;


        public boolean noLight() {
            return this == NO_LIGHT || this == NO_BLOOM_NO_LIGHT;
        }

        public boolean noBloom() {
            return this == NO_BLOOM || this == NO_BLOOM_NO_LIGHT;
        }
    }
}

