/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.fluid;

import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CustomFluidTank
extends FluidTank
implements IFluidHandlerModifiable,
ITagSerializable<CompoundTag>,
IContentChangeAware {
    protected Runnable onContentsChanged;

    public CustomFluidTank(int capacity) {
        this(capacity, e -> true);
    }

    public CustomFluidTank(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
        this.onContentsChanged = () -> {};
    }

    public CustomFluidTank(FluidStack stack) {
        super(stack.getAmount());
        this.onContentsChanged = () -> {};
        this.setFluid(stack);
    }

    protected void onContentsChanged() {
        this.onContentsChanged.run();
    }

    public CustomFluidTank copy() {
        FluidStack copiedStack = this.fluid.copy();
        CustomFluidTank copied = new CustomFluidTank(this.capacity, this.validator);
        copied.setFluid(copiedStack);
        return copied;
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        this.setFluid(stack);
    }

    public void setFluid(FluidStack stack) {
        super.setFluid(stack);
        this.onContentsChanged();
    }

    public CompoundTag serializeNBT() {
        return this.writeToNBT(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readFromNBT(nbt);
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }
}

