/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ParallelLogic {
    public static int getParallelAmount(MetaMachine machine, GTRecipe recipe, int parallelLimit) {
        if (parallelLimit <= 1) {
            return parallelLimit;
        }
        if (!(machine instanceof IRecipeLogicMachine)) {
            return 1;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        int maxInputMultiplier = ParallelLogic.limitByInput(rlm, recipe, parallelLimit);
        if (maxInputMultiplier == 0) {
            return 0;
        }
        return ParallelLogic.limitByOutputMerging(rlm, recipe, maxInputMultiplier, rlm::canVoidRecipeOutputs);
    }

    public static int limitByInput(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelLimit) {
        IntOpenHashSet multipliers = new IntOpenHashSet();
        for (RecipeCapability<?> cap : recipe.inputs.keySet()) {
            if (!cap.doMatchInRecipe()) continue;
            multipliers.add(cap.getMaxParallelRatio(holder, recipe, parallelLimit));
        }
        for (RecipeCapability<?> cap : recipe.tickInputs.keySet()) {
            if (!cap.doMatchInRecipe()) continue;
            multipliers.add(cap.getMaxParallelRatio(holder, recipe, parallelLimit));
        }
        if (multipliers.intStream().allMatch(value -> value == Integer.MAX_VALUE)) {
            return 0;
        }
        return multipliers.intStream().min().orElse(0);
    }

    public static int limitByOutputMerging(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelLimit, Predicate<RecipeCapability<?>> canVoid) {
        boolean voiding;
        Object2IntOpenHashMap modifiedParallelAmounts = new Object2IntOpenHashMap();
        boolean canVoidAll = true;
        for (RecipeCapability<?> cap : recipe.outputs.keySet()) {
            modifiedParallelAmounts.put(cap, Integer.MAX_VALUE);
            if (canVoid.test(cap)) continue;
            canVoidAll = false;
        }
        for (RecipeCapability<?> cap : recipe.tickOutputs.keySet()) {
            modifiedParallelAmounts.put(cap, Integer.MAX_VALUE);
            if (canVoid.test(cap)) continue;
            canVoidAll = false;
        }
        if (canVoidAll) {
            return parallelLimit;
        }
        for (RecipeCapability<?> cap : recipe.outputs.keySet()) {
            if (!cap.doMatchInRecipe() || recipe.getOutputContents(cap).isEmpty()) continue;
            voiding = canVoid.test(cap);
            if (voiding) {
                modifiedParallelAmounts.put(cap, parallelLimit);
            } else {
                modifiedParallelAmounts.put(cap, cap.limitParallel(recipe, holder, parallelLimit));
            }
            if (modifiedParallelAmounts.getInt(cap) != 0 || voiding) continue;
            return 0;
        }
        for (RecipeCapability<?> cap : recipe.tickOutputs.keySet()) {
            if (!cap.doMatchInRecipe() || recipe.getTickOutputContents(cap).isEmpty()) continue;
            voiding = canVoid.test(cap);
            if (voiding) {
                if (modifiedParallelAmounts.containsKey(cap)) {
                    modifiedParallelAmounts.put(cap, Math.min(modifiedParallelAmounts.getInt(cap), parallelLimit));
                } else {
                    modifiedParallelAmounts.put(cap, parallelLimit);
                }
            } else if (modifiedParallelAmounts.containsKey(cap)) {
                modifiedParallelAmounts.put(cap, Math.min(modifiedParallelAmounts.getInt(cap), cap.limitParallel(recipe, holder, parallelLimit)));
            } else {
                modifiedParallelAmounts.put(cap, cap.limitParallel(recipe, holder, parallelLimit));
            }
            if (modifiedParallelAmounts.getInt(cap) != 0 || voiding) continue;
            return 0;
        }
        return modifiedParallelAmounts.values().intStream().min().orElse(0);
    }

    public static int[] adjustMultiplier(boolean mergedAll, int minMultiplier, int multiplier, int maxMultiplier) {
        if (mergedAll) {
            minMultiplier = multiplier;
            int remainder = (maxMultiplier - multiplier) % 2;
            multiplier = multiplier + remainder + (maxMultiplier - multiplier) / 2;
        } else {
            maxMultiplier = multiplier;
            multiplier = (multiplier + minMultiplier) / 2;
        }
        if (maxMultiplier - minMultiplier <= 1) {
            multiplier = maxMultiplier = minMultiplier;
        }
        return new int[]{minMultiplier, multiplier, maxMultiplier};
    }

    public static int getParallelAmountFast(MetaMachine machine, @NotNull GTRecipe recipe, int parallelLimit) {
        IRecipeCapabilityHolder holder;
        if (parallelLimit <= 1) {
            return parallelLimit;
        }
        if (machine instanceof IRecipeCapabilityHolder) {
            holder = (IRecipeCapabilityHolder)((Object)machine);
        } else {
            return 1;
        }
        while (parallelLimit > 0) {
            GTRecipe copied = recipe.copy(ContentModifier.multiplier(parallelLimit), false);
            if (copied.matchRecipe(holder).isSuccess() && copied.matchTickRecipe(holder).isSuccess()) {
                return parallelLimit;
            }
            parallelLimit /= 2;
        }
        return 1;
    }
}

