/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import org.jetbrains.annotations.NotNull;

public class EfficiencyModifier
implements RecipeModifier {
    private final double baseMultiplier;
    private final double efficiency;
    private final double hardCap;
    private final double heuristic;

    private EfficiencyModifier(double baseMultiplier, double efficiency, double hardCap) {
        Preconditions.checkArgument((baseMultiplier > 0.0 ? 1 : 0) != 0, (String)"Base multiplier must be > 0: %s", (Object)baseMultiplier);
        Preconditions.checkArgument((efficiency > 0.0 ? 1 : 0) != 0, (String)"Efficiency must be > 0: %s", (Object)efficiency);
        Preconditions.checkArgument((hardCap >= 0.0 ? 1 : 0) != 0, (String)"Hard cap must be >= 0: %s", (Object)hardCap);
        this.baseMultiplier = baseMultiplier;
        this.efficiency = efficiency;
        this.hardCap = hardCap;
        this.heuristic = 300.0 * efficiency * efficiency;
    }

    public static EfficiencyModifier of(double baseMultiplier, double efficiency, double hardCap) {
        return new EfficiencyModifier(baseMultiplier, efficiency, hardCap);
    }

    public static EfficiencyModifier of(double baseMultiplier, double efficiency) {
        return EfficiencyModifier.of(baseMultiplier, efficiency, 0.5);
    }

    public static EfficiencyModifier of(double efficiency) {
        return EfficiencyModifier.of(2.0, efficiency, 0.5);
    }

    @Override
    @NotNull
    public ModifierFunction getModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof IRecipeLogicMachine)) {
            return RecipeModifier.nullWrongType(IRecipeLogicMachine.class, machine);
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        if (recipe.duration <= 1) {
            return ModifierFunction.IDENTITY;
        }
        int runs = rlm.getRecipeLogic().getConsecutiveRecipes();
        double mult = (double)runs > this.heuristic ? this.hardCap : Math.max(this.hardCap, this.baseMultiplier * Math.pow(this.efficiency, runs));
        return ModifierFunction.builder().durationMultiplier(mult).build();
    }
}

