/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock.part;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockPartMachine
extends MetaMachine
implements IMultiPart {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MultiblockPartMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @DescSynced
    @RequireRerender
    protected final Set<BlockPos> controllerPositions = new HashSet<BlockPos>();

    public MultiblockPartMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean hasController(BlockPos controllerPos) {
        return this.controllerPositions.contains(controllerPos);
    }

    @Override
    public boolean isFormed() {
        return !this.controllerPositions.isEmpty();
    }

    @Override
    public List<IMultiController> getControllers() {
        ArrayList<IMultiController> result = new ArrayList<IMultiController>();
        for (BlockPos blockPos : this.controllerPositions) {
            MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)this.getLevel(), blockPos);
            if (!(metaMachine instanceof IMultiController)) continue;
            IMultiController controller = (IMultiController)((Object)metaMachine);
            result.add(controller);
        }
        return result;
    }

    @Override
    public List<IRecipeHandlerTrait> getRecipeHandlers() {
        return this.traits.stream().filter(IRecipeHandlerTrait.class::isInstance).map(IRecipeHandlerTrait.class::cast).toList();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        Level level = this.getLevel();
        for (BlockPos pos : this.controllerPositions) {
            MetaMachine metaMachine;
            if (!(level instanceof ServerLevel) || !level.m_46749_(pos) || !((metaMachine = MetaMachine.getMachine((BlockGetter)level, pos)) instanceof IMultiController)) continue;
            IMultiController controller = (IMultiController)((Object)metaMachine);
            this.removedFromController(controller);
            controller.onPartUnload();
        }
        this.controllerPositions.clear();
    }

    @Override
    public void removedFromController(IMultiController controller) {
        this.controllerPositions.remove(controller.self().getPos());
    }

    @Override
    public void addedToController(IMultiController controller) {
        this.controllerPositions.add(controller.self().getPos());
    }
}

