/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import java.util.function.Supplier;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.Level;

public class ConditionalSubscriptionHandler {
    private final ITickSubscription handler;
    private final Runnable runnable;
    private final Supplier<Boolean> condition;
    private TickableSubscription subscription;

    public ConditionalSubscriptionHandler(ITickSubscription handler, Runnable runnable, Supplier<Boolean> condition) {
        this.handler = handler;
        this.runnable = runnable;
        this.condition = condition;
    }

    public void initialize(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize((BlockableEventLoop<TickTask>)serverLevel.m_7654_());
        }
    }

    protected void initialize(BlockableEventLoop<TickTask> server) {
        server.m_6937_((Runnable)new TickTask(0, this::updateSubscription));
    }

    public void updateSubscription() {
        if (this.condition.get().booleanValue()) {
            this.subscription = this.handler.subscribeServerTick(this.subscription, this.runnable);
        } else if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    public void unsubscribe() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

