/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.function.DoubleSupplier;

@LDLRegister(name="dual_progress", group="widget.group")
public class DualProgressWidget
extends WidgetGroup {
    private DoubleSupplier progressSupplier;
    @Configurable
    @NumberRange(range={0.001, 1.0}, wheel=0.01)
    private double splitPoint;
    @Configurable(subConfigurable=true)
    private ProgressWidget texture1;
    @Configurable(subConfigurable=true)
    private ProgressWidget texture2;

    public DualProgressWidget() {
        this(ProgressWidget.JEIProgress, 0.5);
    }

    public DualProgressWidget(DoubleSupplier progress, double splitPoint) {
        this(new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 16, 16), new ProgressWidget(ProgressWidget.JEIProgress, 16, 0, 16, 16), progress, splitPoint);
    }

    public DualProgressWidget(ProgressWidget texture1, ProgressWidget texture2, DoubleSupplier progress, double splitPoint) {
        this.progressSupplier = progress;
        this.splitPoint = splitPoint;
        this.texture1 = texture1.setProgressSupplier(() -> progress.getAsDouble() >= splitPoint ? 1.0 : 1.0 / splitPoint * progress.getAsDouble());
        this.texture2 = texture2.setProgressSupplier(() -> progress.getAsDouble() >= splitPoint ? 1.0 / (1.0 - splitPoint) * (progress.getAsDouble() - splitPoint) : 0.0);
        this.addWidget((Widget)this.texture1).addWidget((Widget)this.texture2);
    }

    public DualProgressWidget setTexture1(ProgressWidget widget) {
        this.removeWidget((Widget)this.texture1);
        this.texture1 = widget.setProgressSupplier(() -> this.progressSupplier.getAsDouble() >= this.splitPoint ? 1.0 : 1.0 / this.splitPoint * this.progressSupplier.getAsDouble());
        this.addWidget((Widget)this.texture1);
        return this;
    }

    public DualProgressWidget setTexture2(ProgressWidget widget) {
        this.removeWidget((Widget)this.texture2);
        this.texture2 = widget.setProgressSupplier(() -> this.progressSupplier.getAsDouble() >= this.splitPoint ? 1.0 / (1.0 - this.splitPoint) * (this.progressSupplier.getAsDouble() - this.splitPoint) : 0.0);
        this.addWidget((Widget)this.texture2);
        return this;
    }

    public DualProgressWidget setProgressSupplier(DoubleSupplier progressSupplier) {
        this.progressSupplier = progressSupplier;
        this.widgets.clear();
        this.texture1.setProgressSupplier(() -> progressSupplier.getAsDouble() >= this.splitPoint ? 1.0 : 1.0 / this.splitPoint * progressSupplier.getAsDouble());
        this.addWidget((Widget)this.texture1);
        this.texture2.setProgressSupplier(() -> progressSupplier.getAsDouble() >= this.splitPoint ? 1.0 / (1.0 - this.splitPoint) * (progressSupplier.getAsDouble() - this.splitPoint) : 0.0);
        this.addWidget((Widget)this.texture2);
        return this;
    }

    public DualProgressWidget setSplitPoint(double splitPoint) {
        this.splitPoint = splitPoint;
        this.widgets.clear();
        this.texture1.setProgressSupplier(() -> this.progressSupplier.getAsDouble() >= splitPoint ? 1.0 : 1.0 / splitPoint * this.progressSupplier.getAsDouble());
        this.addWidget((Widget)this.texture1);
        this.texture2.setProgressSupplier(() -> this.progressSupplier.getAsDouble() >= splitPoint ? 1.0 / (1.0 - splitPoint) * (this.progressSupplier.getAsDouble() - splitPoint) : 0.0);
        this.addWidget((Widget)this.texture2);
        return this;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        for (Configurator configurator : father.getConfigurators()) {
            if (this.setConfiguratorIfProgress(configurator) || !(configurator instanceof ConfiguratorGroup)) continue;
            ConfiguratorGroup group = (ConfiguratorGroup)configurator;
            for (Configurator subConfigurator : group.getConfigurators()) {
                this.setConfiguratorIfProgress(subConfigurator);
            }
        }
    }

    private boolean setConfiguratorIfProgress(Configurator configurator) {
        if (configurator instanceof WrapperConfigurator) {
            WrapperConfigurator guiConfigurator = (WrapperConfigurator)configurator;
            Widget widget = guiConfigurator.inner;
            if (widget instanceof ProgressWidget) {
                ProgressWidget progressWidget = (ProgressWidget)widget;
                if (configurator.getName().equals("texture1")) {
                    this.setTexture1(progressWidget);
                    return true;
                }
                if (configurator.getName().equals("texture2")) {
                    this.setTexture2(progressWidget);
                    return true;
                }
            }
        }
        return false;
    }

    public ProgressWidget getTexture1() {
        return this.texture1;
    }

    public ProgressWidget getTexture2() {
        return this.texture2;
    }
}

