/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyCustomClientActionHandler;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyCustomMiddleClickAction;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyCustomMouseWheelAction;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.animation.Animation;
import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import com.lowdragmc.lowdraglib.utils.interpolate.IEase;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguratorPanel
extends WidgetGroup {
    protected List<Tab> tabs = new ArrayList<Tab>();
    @Nullable
    protected Tab expanded;
    protected int border = 4;
    protected IGuiTexture texture = GuiTextures.BACKGROUND;

    public ConfiguratorPanel(int x, int y) {
        super(x, y, 24, 0);
    }

    public void clear() {
        this.clearAllWidgets();
        this.tabs.clear();
        this.expanded = null;
    }

    public int getTabSize() {
        return this.getSize().width;
    }

    public void attachConfigurators(IFancyConfigurator ... fancyConfigurators) {
        for (IFancyConfigurator fancyConfigurator : fancyConfigurators) {
            Tab tab = new Tab(fancyConfigurator);
            tab.setBackground(new IGuiTexture[]{this.texture});
            this.tabs.add(tab);
            this.addWidgetAnima((Widget)tab, new Transform().scale(0.0f).duration((long)ConfiguratorPanel.getAnimationTime()).ease((IEase)Eases.EaseQuadOut));
        }
        this.setSize(new Size(this.getSize().width, Math.max(0, this.tabs.size() * (this.getTabSize() + 2) - 2)));
    }

    public void expandTab(Tab tab) {
        tab.expand();
        int i = 0;
        for (Tab otherTab : this.tabs) {
            if (otherTab == tab) continue;
            otherTab.collapseTo(0, i++ * (this.getTabSize() + 2));
        }
        this.expanded = tab;
    }

    public void collapseTab() {
        if (this.expanded != null) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                this.tabs.get(i).collapseTo(0, i * (this.getTabSize() + 2));
            }
            if (this.expanded instanceof FloatingTab) {
                this.expanded.collapseTo(0, 0);
            }
        }
        this.expanded = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawWidgetsBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || widget == this.expanded) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (widget.inAnimate()) {
                widget.getAnimation().drawInBackground(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            widget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.expanded != null && this.expanded.isVisible()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (this.expanded.inAnimate()) {
                this.expanded.getAnimation().drawInBackground(graphics, mouseX, mouseY, partialTicks);
            } else {
                this.expanded.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawWidgetsForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.gui.getModularUIGui().setHoverTooltip(Collections.emptyList(), ItemStack.f_41583_, null, null);
        }
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || widget == this.expanded) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (widget.inAnimate()) {
                widget.getAnimation().drawInForeground(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            widget.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.expanded != null && this.expanded.isVisible()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (this.expanded.inAnimate()) {
                this.expanded.getAnimation().drawInForeground(graphics, mouseX, mouseY, partialTicks);
            } else {
                this.expanded.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.expanded != null && this.expanded.isVisible() && this.expanded.isActive() && this.expanded.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public FloatingTab createFloatingTab(IFancyConfigurator configurator) {
        return new FloatingTab(configurator);
    }

    private static int getAnimationTime() {
        return ConfigHolder.INSTANCE.client.animationTime;
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    @Nullable
    public Tab getExpanded() {
        return this.expanded;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public void setTexture(IGuiTexture texture) {
        this.texture = texture;
    }

    public class Tab
    extends WidgetGroup {
        protected final IFancyConfigurator configurator;
        protected final ButtonWidget button;
        @Nullable
        protected final WidgetGroup view;
        protected double lastDeltaX;
        protected double lastDeltaY;
        protected int dragOffsetX;
        protected int dragOffsetY;
        protected boolean isDragging;

        public Tab(final IFancyConfigurator configurator) {
            super(0, ConfiguratorPanel.this.tabs.size() * (ConfiguratorPanel.this.getTabSize() + 2), ConfiguratorPanel.this.getTabSize(), ConfiguratorPanel.this.getTabSize());
            this.configurator = configurator;
            this.button = new ButtonWidget(0, 0, ConfiguratorPanel.this.getTabSize(), ConfiguratorPanel.this.getTabSize(), null, this::onClick){

                public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
                    if (!(configurator instanceof IFancyCustomMouseWheelAction)) {
                        return false;
                    }
                    IFancyCustomMouseWheelAction hasActions = (IFancyCustomMouseWheelAction)((Object)configurator);
                    if (this.isMouseOverElement(mouseX, mouseY)) {
                        return hasActions.mouseWheelMove((x$0, x$1) -> this.writeClientAction((int)x$0, (Consumer)x$1), mouseX, mouseY, wheelDelta);
                    }
                    return false;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void handleClientAction(int id, FriendlyByteBuf buffer) {
                    if (configurator instanceof IFancyCustomClientActionHandler) {
                        IFancyCustomClientActionHandler handler = (IFancyCustomClientActionHandler)((Object)configurator);
                        if (id > 1) {
                            handler.handleClientAction(id, buffer);
                            return;
                        }
                    }
                    super.handleClientAction(id, buffer);
                }
            };
            if (configurator instanceof IFancyConfiguratorButton) {
                this.view = null;
                this.addWidget((Widget)this.button);
            } else {
                final Widget widget = configurator.createConfigurator();
                widget.setSelfPosition(new Position(ConfiguratorPanel.this.border, ConfiguratorPanel.this.getTabSize()));
                this.view = new WidgetGroup(0, 0, 0, 0){

                    protected void onChildSizeUpdate(Widget child) {
                        super.onChildSizeUpdate(child);
                        if (widget == child) {
                            this.setSize(new Size(widget.getSize().width + ConfiguratorPanel.this.border * 2, widget.getSize().height + ConfiguratorPanel.this.getTabSize() + ConfiguratorPanel.this.border));
                        }
                    }
                };
                this.view.setVisible(false);
                this.view.setActive(false);
                this.view.setSize(new Size(widget.getSize().width + ConfiguratorPanel.this.border * 2, widget.getSize().height + this.button.getSize().height + ConfiguratorPanel.this.border));
                this.view.addWidget(widget);
                this.view.addWidget((Widget)new ImageWidget(ConfiguratorPanel.this.border + 5, ConfiguratorPanel.this.border, widget.getSize().width - ConfiguratorPanel.this.getTabSize() - 5, ConfiguratorPanel.this.getTabSize() - ConfiguratorPanel.this.border, (IGuiTexture)new TextTexture(configurator.getTitle().getString()).setType(TextTexture.TextType.LEFT_HIDE).setWidth(widget.getSize().width - ConfiguratorPanel.this.getTabSize())));
                this.addWidget((Widget)this.button);
                this.addWidget((Widget)this.view);
            }
        }

        public void writeInitialData(FriendlyByteBuf buffer) {
            super.writeInitialData(buffer);
            this.configurator.writeInitialData(buffer);
        }

        public void readInitialData(FriendlyByteBuf buffer) {
            super.readInitialData(buffer);
            this.configurator.readInitialData(buffer);
        }

        public void detectAndSendChanges() {
            super.detectAndSendChanges();
            this.configurator.detectAndSendChange((id, sender) -> this.writeUpdateInfo(0, buf -> {
                buf.m_130130_(id.intValue());
                sender.accept(buf);
            }));
        }

        public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
            if (id == 0) {
                this.configurator.readUpdateInfo(buffer.m_130242_(), buffer);
            } else {
                super.readUpdateInfo(id, buffer);
            }
        }

        protected void onChildSizeUpdate(Widget child) {
            if (this.view != null && this.view == child && ConfiguratorPanel.this.expanded == this) {
                Size size = this.view.getSize();
                this.animation(new Animation().duration((long)ConfiguratorPanel.getAnimationTime()).position(new Position(this.dragOffsetX + (-size.width + (ConfiguratorPanel.this.tabs.size() > 1 ? -2 : ConfiguratorPanel.this.getTabSize())), this.dragOffsetY)).size(size).ease((IEase)Eases.EaseQuadOut).onFinish(() -> {
                    this.view.setVisible(true);
                    this.view.setActive(true);
                }));
            }
        }

        private void onClick(ClickData clickData) {
            IFancyConfigurator iFancyConfigurator;
            if (clickData.button == 2 && (iFancyConfigurator = this.configurator) instanceof IFancyCustomMiddleClickAction) {
                IFancyCustomMiddleClickAction middleAction = (IFancyCustomMiddleClickAction)((Object)iFancyConfigurator);
                middleAction.onMiddleClick((x$0, x$1) -> this.writeClientAction((int)x$0, (Consumer)x$1));
            } else {
                iFancyConfigurator = this.configurator;
                if (iFancyConfigurator instanceof IFancyConfiguratorButton) {
                    IFancyConfiguratorButton fancyButton = (IFancyConfiguratorButton)iFancyConfigurator;
                    fancyButton.onClick(clickData);
                } else if (ConfiguratorPanel.this.expanded == this) {
                    ConfiguratorPanel.this.collapseTab();
                } else {
                    ConfiguratorPanel.this.expandTab(this);
                }
            }
        }

        public void setSize(Size size) {
            super.setSize(size);
            this.button.setSelfPosition(new Position(size.width - ConfiguratorPanel.this.getTabSize(), 0));
        }

        private void expand() {
            if (this.view == null) {
                return;
            }
            Size size = this.view.getSize();
            this.dragOffsetX = 0;
            this.dragOffsetY = 0;
            if (this.isRemote()) {
                if (this.getParentPosition().x - size.width + (ConfiguratorPanel.this.tabs.size() > 1 ? -2 : ConfiguratorPanel.this.getTabSize()) < 0) {
                    this.dragOffsetX -= this.view.getParentPosition().x - size.width + (ConfiguratorPanel.this.tabs.size() > 1 ? -2 : ConfiguratorPanel.this.getTabSize());
                }
                if (this.getParentPosition().y + size.height > this.gui.getScreenHeight()) {
                    this.dragOffsetY -= this.view.getParentPosition().y + size.height - this.gui.getScreenHeight();
                }
            }
            Position position = new Position(this.dragOffsetX - size.width + (ConfiguratorPanel.this.tabs.size() > 1 ? -2 : ConfiguratorPanel.this.getTabSize()), this.dragOffsetY);
            this.animation(new Animation().duration((long)ConfiguratorPanel.getAnimationTime()).position(position).size(size).ease((IEase)Eases.EaseQuadOut).onFinish(() -> {
                this.view.setVisible(true);
                this.view.setActive(true);
            }));
        }

        protected void collapseTo(int x, int y) {
            if (this.view != null) {
                this.view.setVisible(false);
                this.view.setActive(false);
            }
            this.animation(new Animation().duration((long)ConfiguratorPanel.getAnimationTime()).position(new Position(x, y)).size(new Size(ConfiguratorPanel.this.getTabSize(), ConfiguratorPanel.this.getTabSize())).ease((IEase)Eases.EaseQuadOut));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.drawBackgroundTexture(graphics, mouseX, mouseY);
            Position position = this.getPosition();
            Size size = this.getSize();
            if (this.inAnimate()) {
                graphics.m_280588_(position.x + ConfiguratorPanel.this.border - 1, position.y + ConfiguratorPanel.this.border - 1, position.x + ConfiguratorPanel.this.border - 1 + size.width - (ConfiguratorPanel.this.border - 1) * 2, position.y + ConfiguratorPanel.this.border - 1 + size.height - (ConfiguratorPanel.this.border - 1) * 2);
                this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
                graphics.m_280618_();
            } else {
                this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
            }
            this.configurator.getIcon().draw(graphics, mouseX, mouseY, (float)(position.x + size.width - 20), (float)(position.y + 4), 16, 16);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            if (Tab.isMouseOver((int)(this.getPosition().x + this.getSize().width - 20), (int)(this.getPosition().y + 4), (int)16, (int)16, (double)mouseX, (double)mouseY) && this.gui != null && this.gui.getModularUIGui() != null) {
                this.gui.getModularUIGui().setHoverTooltip(this.configurator.getTooltips(), ItemStack.f_41583_, null, null);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.lastDeltaX = 0.0;
            this.lastDeltaY = 0.0;
            this.isDragging = false;
            if (ConfiguratorPanel.this.expanded == this && Tab.isMouseOver((int)this.getPosition().x, (int)this.getPosition().y, (int)(this.getSize().width - ConfiguratorPanel.this.getTabSize()), (int)ConfiguratorPanel.this.getTabSize(), (double)mouseX, (double)mouseY)) {
                this.isDragging = true;
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button) || this.isMouseOverElement(mouseX, mouseY);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            double dx = dragX + this.lastDeltaX;
            double dy = dragY + this.lastDeltaY;
            dragX = (int)dx;
            dragY = (int)dy;
            this.lastDeltaX = dx - dragX;
            this.lastDeltaY = dy - dragY;
            if (this.isDragging) {
                this.dragOffsetX += (int)dragX;
                this.dragOffsetY += (int)dragY;
                this.addSelfPosition((int)dragX, (int)dragY);
            }
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY) || this.isMouseOverElement(mouseX, mouseY);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            this.lastDeltaX = 0.0;
            this.lastDeltaY = 0.0;
            this.isDragging = false;
            return super.mouseReleased(mouseX, mouseY, button) || this.isMouseOverElement(mouseX, mouseY);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
            return super.mouseWheelMove(mouseX, mouseY, wheelDelta) || this.isMouseOverElement(mouseX, mouseY);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean mouseMoved(double mouseX, double mouseY) {
            return super.mouseMoved(mouseX, mouseY) || this.isMouseOverElement(mouseX, mouseY);
        }
    }

    public class FloatingTab
    extends Tab {
        protected Runnable closeCallback;

        public FloatingTab(IFancyConfigurator configurator) {
            super(configurator);
            this.closeCallback = () -> {};
            this.view.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND});
        }

        @Override
        public void collapseTo(int x, int y) {
            super.collapseTo(x, y);
            ConfiguratorPanel.this.removeWidget((Widget)this);
            this.closeCallback.run();
        }

        public void onClose(Runnable closeCallback) {
            this.closeCallback = closeCallback;
        }
    }
}

