/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.config.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.ArrayUtils;

public class ToolProperty
implements IMaterialProperty {
    private float harvestSpeed;
    private float attackDamage;
    private float attackSpeed;
    private int durability;
    private int harvestLevel;
    private int enchantability = 10;
    private boolean ignoreCraftingTools;
    private boolean isUnbreakable;
    private boolean isMagnetic;
    private int durabilityMultiplier = 1;
    private MaterialToolTier toolTier;
    private GTToolType[] types;
    private final Object2IntMap<Enchantment> enchantments = new Object2IntArrayMap();

    public ToolProperty(float harvestSpeed, float attackDamage, int durability, int harvestLevel, GTToolType[] types) {
        this.harvestSpeed = harvestSpeed;
        this.attackDamage = attackDamage;
        this.durability = durability;
        this.harvestLevel = harvestLevel;
        this.types = types;
    }

    public ToolProperty() {
        this(1.0f, 1.0f, 100, 2, (GTToolType[])GTToolType.getTypes().values().toArray(GTToolType[]::new));
    }

    public Object2IntMap<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (!properties.hasProperty(PropertyKey.WOOD) && !properties.hasProperty(PropertyKey.GEM)) {
            properties.ensureSet(PropertyKey.INGOT, true);
        }
    }

    public void addEnchantmentForTools(Enchantment enchantment, int level) {
        if (ConfigHolder.INSTANCE.recipes.enchantedTools) {
            this.enchantments.put((Object)enchantment, level);
        }
    }

    public MaterialToolTier getTier(Material material) {
        if (this.toolTier == null) {
            this.toolTier = new MaterialToolTier(material);
        }
        return this.toolTier;
    }

    public boolean hasType(GTToolType toolType) {
        return ArrayUtils.contains((Object[])this.types, (Object)toolType);
    }

    public ToolProperty addTypes(GTToolType ... types) {
        this.types = (GTToolType[])ArrayUtils.addAll((Object[])this.types, (Object[])types);
        return this;
    }

    public ToolProperty removeTypes(GTToolType ... types) {
        this.types = (GTToolType[])Arrays.stream(this.types).filter(type -> !ArrayUtils.contains((Object[])types, (Object)type)).toArray(GTToolType[]::new);
        return this;
    }

    public float getHarvestSpeed() {
        return this.harvestSpeed;
    }

    public void setHarvestSpeed(float harvestSpeed) {
        this.harvestSpeed = harvestSpeed;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public void setAttackSpeed(float attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    public int getDurability() {
        return this.durability;
    }

    public void setDurability(int durability) {
        this.durability = durability;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public void setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public void setEnchantability(int enchantability) {
        this.enchantability = enchantability;
    }

    public boolean isIgnoreCraftingTools() {
        return this.ignoreCraftingTools;
    }

    public void setIgnoreCraftingTools(boolean ignoreCraftingTools) {
        this.ignoreCraftingTools = ignoreCraftingTools;
    }

    public boolean isUnbreakable() {
        return this.isUnbreakable;
    }

    public void setUnbreakable(boolean isUnbreakable) {
        this.isUnbreakable = isUnbreakable;
    }

    public boolean isMagnetic() {
        return this.isMagnetic;
    }

    public void setMagnetic(boolean isMagnetic) {
        this.isMagnetic = isMagnetic;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public void setDurabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
    }

    public GTToolType[] getTypes() {
        return this.types;
    }

    public void setTypes(GTToolType[] types) {
        this.types = types;
    }

    public static class Builder {
        private final ToolProperty toolProperty;

        public static Builder of(float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
            return new Builder(harvestSpeed, attackDamage, durability, harvestLevel, new GTToolType[]{GTToolType.SWORD, GTToolType.PICKAXE, GTToolType.SHOVEL, GTToolType.AXE, GTToolType.HOE, GTToolType.MINING_HAMMER, GTToolType.SPADE, GTToolType.SAW, GTToolType.HARD_HAMMER, GTToolType.WRENCH, GTToolType.FILE, GTToolType.CROWBAR, GTToolType.SCREWDRIVER, GTToolType.WIRE_CUTTER, GTToolType.SCYTHE, GTToolType.KNIFE, GTToolType.BUTCHERY_KNIFE, GTToolType.DRILL_LV, GTToolType.DRILL_MV, GTToolType.DRILL_HV, GTToolType.DRILL_EV, GTToolType.DRILL_IV, GTToolType.CHAINSAW_LV, GTToolType.WRENCH_LV, GTToolType.WRENCH_HV, GTToolType.WRENCH_IV, GTToolType.BUZZSAW, GTToolType.SCREWDRIVER_LV, GTToolType.WIRE_CUTTER_LV, GTToolType.WIRE_CUTTER_HV, GTToolType.WIRE_CUTTER_IV});
        }

        public static Builder of(float harvestSpeed, float attackDamage, int durability, int harvestLevel, GTToolType ... types) {
            return new Builder(harvestSpeed, attackDamage, durability, harvestLevel, types);
        }

        private Builder(float harvestSpeed, float attackDamage, int durability, int harvestLevel, GTToolType[] types) {
            this.toolProperty = new ToolProperty(harvestSpeed, attackDamage, durability, harvestLevel, types);
        }

        public Builder enchantability(int enchantability) {
            this.toolProperty.enchantability = enchantability;
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.toolProperty.attackSpeed = attackSpeed;
            return this;
        }

        public Builder ignoreCraftingTools() {
            this.toolProperty.ignoreCraftingTools = true;
            return this;
        }

        public Builder unbreakable() {
            this.toolProperty.isUnbreakable = true;
            return this;
        }

        public Builder types(GTToolType ... types) {
            this.toolProperty.types = types;
            return this;
        }

        public Builder addTypes(GTToolType ... types) {
            this.toolProperty.types = (GTToolType[])ArrayUtils.addAll((Object[])this.toolProperty.types, (Object[])types);
            return this;
        }

        public Builder enchantment(Enchantment enchantment, int level) {
            this.toolProperty.addEnchantmentForTools(enchantment, level);
            return this;
        }

        public Builder magnetic() {
            this.toolProperty.isMagnetic = true;
            return this;
        }

        public Builder durabilityMultiplier(int multiplier) {
            this.toolProperty.durabilityMultiplier = multiplier;
            return this;
        }

        public ToolProperty build() {
            return this.toolProperty;
        }
    }
}

