/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.codec;

import com.gregtechceu.gtceu.GTCEu;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;

public record DispatchedMapCodec<K, V>(Codec<K> keyCodec, Function<K, Codec<? extends V>> valueCodecFunction) implements Codec<Map<K, V>>
{
    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        RecordBuilder mapBuilder = ops.mapBuilder();
        for (Map.Entry<K, V> entry : input.entrySet()) {
            mapBuilder.add(this.keyCodec.encodeStart(ops, entry.getKey()), this.encodeValue(this.valueCodecFunction.apply(entry.getKey()), entry.getValue(), ops));
        }
        return mapBuilder.build(prefix);
    }

    private <T, V2 extends V> DataResult<T> encodeValue(Codec<V2> codec, V input, DynamicOps<T> ops) {
        return codec.encodeStart(ops, input);
    }

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).flatMap(map -> {
            Object2ObjectArrayMap entries = new Object2ObjectArrayMap();
            Stream.Builder failed = Stream.builder();
            DataResult finalResult = map.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (arg_0, arg_1) -> this.lambda$decode$0(ops, (Map)entries, failed, arg_0, arg_1), (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
            Pair pair = Pair.of((Object)new Object2ObjectArrayMap((Map)entries), (Object)input);
            Object errors = ops.createMap(failed.build());
            return finalResult.map(ignored -> pair).setPartial((Object)pair).mapError(error -> error + " missed input: " + errors);
        });
    }

    private <T> DataResult<Unit> parseEntry(DataResult<Unit> result, DynamicOps<T> ops, Pair<T, T> input, Map<K, V> entries, Stream.Builder<Pair<T, T>> failed) {
        Object value;
        Object key;
        DataResult keyResult = this.keyCodec.parse(ops, input.getFirst());
        DataResult valueResult = keyResult.map(this.valueCodecFunction).flatMap(valueCodec -> valueCodec.parse(ops, input.getSecond()).map(Function.identity()));
        DataResult entryResult = keyResult.apply2stable(Pair::of, valueResult);
        Optional entry = entryResult.resultOrPartial(arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
        if (entry.isPresent() && entries.putIfAbsent(key = ((Pair)entry.get()).getFirst(), value = ((Pair)entry.get()).getSecond()) != null) {
            failed.add(input);
            return result.apply2stable((u, p) -> u, DataResult.error(() -> "Duplicate entry for key: '" + key + "'"));
        }
        if (entryResult.error().isPresent()) {
            failed.add(input);
        }
        return result.apply2stable((u, p) -> u, entryResult);
    }

    private /* synthetic */ DataResult lambda$decode$0(DynamicOps ops, Map entries, Stream.Builder failed, DataResult result, Pair entry) {
        return this.parseEntry((DataResult<Unit>)result, ops, entry, entries, failed);
    }
}

