/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapIntersectionIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackNBTIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackPartialNBTIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemTagIngredient;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.common.valueprovider.AddedFloat;
import com.gregtechceu.gtceu.common.valueprovider.CastedFloat;
import com.gregtechceu.gtceu.common.valueprovider.FlooredInt;
import com.gregtechceu.gtceu.common.valueprovider.MultipliedFloat;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.IntersectionIngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemStackList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemTagList;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemEntryHandler;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemStackHandler;
import com.gregtechceu.gtceu.integration.xei.widgets.GTRecipeWidget;
import com.gregtechceu.gtceu.utils.GTHashMaps;
import com.gregtechceu.gtceu.utils.IngredientEquality;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.gregtechceu.gtceu.utils.OverlayedItemHandler;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class ItemRecipeCapability
extends RecipeCapability<Ingredient> {
    public static final ItemRecipeCapability CAP = new ItemRecipeCapability();

    protected ItemRecipeCapability() {
        super("item", -2531066, true, 0, SerializerIngredient.INSTANCE);
    }

    @Override
    public Ingredient copyInner(Ingredient content) {
        return SizedIngredient.copy(content);
    }

    @Override
    public Ingredient copyWithModifier(Ingredient content, ContentModifier modifier) {
        if (content instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)content;
            return SizedIngredient.create(sizedIngredient.getInner(), modifier.apply(sizedIngredient.getAmount()));
        }
        if (content instanceof IntProviderIngredient) {
            IntProviderIngredient intProviderIngredient = (IntProviderIngredient)content;
            return new IntProviderIngredient(intProviderIngredient.getInner(), (IntProvider)new FlooredInt(new AddedFloat(new MultipliedFloat(new CastedFloat(intProviderIngredient.getCountProvider()), (FloatProvider)ConstantFloat.m_146458_((float)((float)modifier.multiplier()))), (FloatProvider)ConstantFloat.m_146458_((float)((float)modifier.addition())))));
        }
        return SizedIngredient.create(content, modifier.apply(1));
    }

    @Override
    public List<AbstractMapIngredient> convertToMapIngredient(Object obj) {
        ObjectArrayList ingredients = new ObjectArrayList(1);
        if (obj instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)obj;
            if (ingredient instanceof StrictNBTIngredient) {
                StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient;
                ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
            } else if (ingredient instanceof PartialNBTIngredient) {
                PartialNBTIngredient nbt = (PartialNBTIngredient)ingredient;
                ingredients.addAll(MapItemStackPartialNBTIngredient.from(nbt));
            } else if (ingredient instanceof SizedIngredient) {
                SizedIngredient sized = (SizedIngredient)ingredient;
                Ingredient ingredient2 = sized.getInner();
                if (ingredient2 instanceof StrictNBTIngredient) {
                    StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient2;
                    ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
                } else {
                    ingredient2 = sized.getInner();
                    if (ingredient2 instanceof PartialNBTIngredient) {
                        PartialNBTIngredient nbt = (PartialNBTIngredient)ingredient2;
                        ingredients.addAll(MapItemStackPartialNBTIngredient.from(nbt));
                    } else {
                        ingredient2 = sized.getInner();
                        if (ingredient2 instanceof IntersectionIngredient) {
                            IntersectionIngredient intersection = (IntersectionIngredient)ingredient2;
                            ingredients.add(new MapIntersectionIngredient(intersection));
                        } else {
                            for (Ingredient.Value value : ((IngredientAccessor)sized.getInner()).getValues()) {
                                if (value instanceof Ingredient.TagValue) {
                                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                                    ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                                    continue;
                                }
                                Collection stacks = value.m_6223_();
                                for (ItemStack stack : stacks) {
                                    ingredients.add(new MapItemStackIngredient(stack, sized.getInner()));
                                }
                            }
                        }
                    }
                }
            } else if (ingredient instanceof IntProviderIngredient) {
                IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
                Ingredient ingredient3 = intProvider.getInner();
                if (ingredient3 instanceof StrictNBTIngredient) {
                    StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient3;
                    ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
                } else {
                    ingredient3 = intProvider.getInner();
                    if (ingredient3 instanceof PartialNBTIngredient) {
                        PartialNBTIngredient nbt = (PartialNBTIngredient)ingredient3;
                        ingredients.addAll(MapItemStackPartialNBTIngredient.from(nbt));
                    } else {
                        ingredient3 = intProvider.getInner();
                        if (ingredient3 instanceof IntersectionIngredient) {
                            IntersectionIngredient intersection = (IntersectionIngredient)ingredient3;
                            ingredients.add(new MapIntersectionIngredient(intersection));
                        } else {
                            for (Ingredient.Value value : ((IngredientAccessor)intProvider.getInner()).getValues()) {
                                if (value instanceof Ingredient.TagValue) {
                                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                                    ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                                    continue;
                                }
                                Collection stacks = value.m_6223_();
                                for (ItemStack stack : stacks) {
                                    ingredients.add(new MapItemStackIngredient(stack, intProvider.getInner()));
                                }
                            }
                        }
                    }
                }
            } else if (ingredient instanceof IntersectionIngredient) {
                IntersectionIngredient intersection = (IntersectionIngredient)ingredient;
                ingredients.add(new MapIntersectionIngredient(intersection));
            } else {
                for (Ingredient.Value value : ((IngredientAccessor)ingredient).getValues()) {
                    if (value instanceof Ingredient.TagValue) {
                        Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                        ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                        continue;
                    }
                    Collection stacks = value.m_6223_();
                    for (ItemStack stack : stacks) {
                        ingredients.add(new MapItemStackIngredient(stack, ingredient));
                    }
                }
            }
        } else if (obj instanceof ItemStack) {
            TagPrefix prefix;
            ItemStack stack = (ItemStack)obj;
            ingredients.add(new MapItemStackIngredient(stack));
            stack.m_204131_().forEach(arg_0 -> ItemRecipeCapability.lambda$convertToMapIngredient$0((List)ingredients, arg_0));
            if (stack.m_41782_()) {
                ingredients.add(new MapItemStackNBTIngredient(stack, StrictNBTIngredient.of((ItemStack)stack)));
            }
            if (stack.getShareTag() != null) {
                ingredients.add(new MapItemStackPartialNBTIngredient(stack, PartialNBTIngredient.of((ItemLike)stack.m_41720_(), (CompoundTag)stack.getShareTag())));
            }
            if ((prefix = ChemicalHelper.getPrefix((ItemLike)stack.m_41720_())) != null && TagPrefix.ORES.containsKey(prefix)) {
                Material material = ChemicalHelper.getMaterial((ItemLike)stack.m_41720_()).material();
                ingredients.add(new MapIntersectionIngredient((IntersectionIngredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(prefix.getItemTags(material)[0]), Ingredient.m_204132_(prefix.getItemParentTags()[0])})));
            }
        }
        return ingredients;
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        ObjectArrayList list = new ObjectArrayList(ingredients.size());
        for (Object item : ingredients) {
            boolean isEqual;
            if (item instanceof Ingredient) {
                IntProviderIngredient intProvider;
                SizedIngredient sized;
                Ingredient ingredient = (Ingredient)item;
                isEqual = false;
                for (Object obj : list) {
                    ItemStack stack;
                    if (obj instanceof Ingredient) {
                        Ingredient ingredient1 = (Ingredient)obj;
                        if (!IngredientEquality.ingredientEquals(ingredient, ingredient1)) continue;
                        isEqual = true;
                        break;
                    }
                    if (!(obj instanceof ItemStack) || !ingredient.test(stack = (ItemStack)obj)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                if (ingredient instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                if (ingredient instanceof SizedIngredient && (sized = (SizedIngredient)ingredient).getInner() instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                if (ingredient instanceof IntProviderIngredient && (intProvider = (IntProviderIngredient)ingredient).getInner() instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                list.add(ingredient);
                continue;
            }
            if (!(item instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)item;
            isEqual = false;
            for (Object obj : list) {
                ItemStack stack1;
                if (obj instanceof Ingredient) {
                    Ingredient ingredient = (Ingredient)obj;
                    if (!ingredient.test(stack)) continue;
                    isEqual = true;
                    break;
                }
                if (!(obj instanceof ItemStack) || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)(stack1 = (ItemStack)obj))) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            list.add(stack);
        }
        return list;
    }

    @Override
    public boolean isRecipeSearchFilter() {
        return true;
    }

    @Override
    public int limitParallel(GTRecipe recipe, IRecipeCapabilityHolder holder, int multiplier) {
        if (holder instanceof ICustomParallel) {
            ICustomParallel p = (ICustomParallel)((Object)holder);
            return p.limitParallel(recipe, multiplier);
        }
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        OverlayedItemHandler itemHandler = new OverlayedItemHandler((IItemHandlerModifiable)new CombinedInvWrapper((IItemHandlerModifiable[])Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.OUT, (Object)CAP), Collections::emptyList).stream().filter(IItemHandlerModifiable.class::isInstance).map(IItemHandlerModifiable.class::cast).toArray(IItemHandlerModifiable[]::new)));
        Object2IntMap<ItemStack> recipeOutputs = GTHashMaps.fromItemStackCollection(recipe.getOutputContents(CAP).stream().map(content -> (Ingredient)CAP.of(content.getContent())).filter(ingredient -> !ingredient.m_43947_()).map(ingredient -> ingredient.m_43908_()[0]).toList());
        while (minMultiplier != maxMultiplier) {
            itemHandler.reset();
            int returnedAmount = 0;
            for (Object2IntMap.Entry entry : recipeOutputs.object2IntEntrySet()) {
                int amountToInsert = entry.getIntValue() != 0 && multiplier > Integer.MAX_VALUE / entry.getIntValue() ? Integer.MAX_VALUE : entry.getIntValue() * multiplier;
                returnedAmount = itemHandler.insertStackedItemStack((ItemStack)entry.getKey(), amountToInsert);
                if (returnedAmount <= 0) continue;
                break;
            }
            int[] bin = ParallelLogic.adjustMultiplier(returnedAmount == 0, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = bin[0];
            multiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return multiplier;
    }

    @Override
    public int getMaxParallelRatio(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelAmount) {
        int available;
        Object2IntMap<ItemStack> ingredientStacks = this.getIngredientStacks(holder);
        int minMultiplier = Integer.MAX_VALUE;
        Object2IntOpenHashMap notConsumableMap = new Object2IntOpenHashMap();
        Object2IntOpenHashMap countableMap = new Object2IntOpenHashMap();
        for (Content content : recipe.getInputContents(CAP)) {
            int ingredientCount;
            Ingredient recipeIngredient = (Ingredient)CAP.of(content.content);
            if (recipeIngredient instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)recipeIngredient;
                ingredientCount = sizedIngredient.getAmount();
            } else if (recipeIngredient instanceof IntProviderIngredient) {
                IntProviderIngredient intProviderIngredient = (IntProviderIngredient)recipeIngredient;
                ingredientCount = intProviderIngredient.getSampledCount(GTValues.RNG);
            } else {
                ingredientCount = 1;
            }
            if (content.chance == 0) {
                notConsumableMap.computeIfPresent((Object)recipeIngredient, (k, v) -> v + ingredientCount);
                notConsumableMap.putIfAbsent((Object)recipeIngredient, ingredientCount);
                continue;
            }
            countableMap.computeIfPresent((Object)recipeIngredient, (k, v) -> v + ingredientCount);
            countableMap.putIfAbsent((Object)recipeIngredient, ingredientCount);
        }
        for (Object2IntMap.Entry recipeInputEntry : notConsumableMap.object2IntEntrySet()) {
            int needed = recipeInputEntry.getIntValue();
            available = 0;
            for (Object2IntMap.Entry inventoryEntry : ingredientStacks.object2IntEntrySet()) {
                if (!((Ingredient)recipeInputEntry.getKey()).test((ItemStack)inventoryEntry.getKey())) continue;
                available = inventoryEntry.getIntValue();
                if (available > needed) {
                    inventoryEntry.setValue(available - needed);
                    needed -= available;
                    break;
                }
                inventoryEntry.setValue(0);
                recipeInputEntry.setValue(needed - available);
                needed -= available;
            }
            if (needed < available) continue;
            return 0;
        }
        if (countableMap.isEmpty() && !notConsumableMap.isEmpty()) {
            return parallelAmount;
        }
        for (Object2IntMap.Entry recipeInputEntry : countableMap.object2IntEntrySet()) {
            int needed = recipeInputEntry.getIntValue();
            available = 0;
            for (Object2IntMap.Entry inventoryEntry : ingredientStacks.object2IntEntrySet()) {
                if (!((Ingredient)recipeInputEntry.getKey()).test((ItemStack)inventoryEntry.getKey())) continue;
                available += inventoryEntry.getIntValue();
                break;
            }
            if (available >= needed) {
                int ratio = Math.min(parallelAmount, available / needed);
                if (ratio >= minMultiplier) continue;
                minMultiplier = ratio;
                continue;
            }
            return 0;
        }
        return minMultiplier;
    }

    private Object2IntMap<ItemStack> getIngredientStacks(IRecipeCapabilityHolder holder) {
        Object2IntOpenCustomHashMap map = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        List<IRecipeHandler> recipeHandlerList = Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)CAP), Collections::emptyList).stream().filter(handler -> !handler.isProxy()).toList();
        for (IRecipeHandler container : recipeHandlerList) {
            Object2IntOpenCustomHashMap itemMap = container.getContents().stream().filter(ItemStack.class::isInstance).map(ItemStack.class::cast).flatMap(con -> GTHashMaps.fromItemStackCollection(Collections.singleton(con)).object2IntEntrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, () -> new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount())));
            if (container.isDistinct()) {
                result.putAll((Map)itemMap);
                continue;
            }
            for (Object2IntMap.Entry obj : itemMap.object2IntEntrySet()) {
                map.computeInt((Object)((ItemStack)obj.getKey()), (k, v) -> v == null ? obj.getIntValue() : v + obj.getIntValue());
            }
        }
        result.putAll((Map)map);
        return result;
    }

    @Override
    @NotNull
    public List<Object> createXEIContainerContents(List<Content> contents, GTRecipe recipe, IO io) {
        ArrayList<ItemEntryList> entryLists = contents.stream().map(Content::getContent).map(this::of).map(ItemRecipeCapability::mapItem).collect(Collectors.toList());
        ArrayList<ItemEntryList> scannerPossibilities = null;
        if (io == IO.OUT && recipe.recipeType.isScanner()) {
            scannerPossibilities = new ArrayList<ItemEntryList>();
            Pair<GTRecipeType, String> researchData = null;
            for (Content stack : recipe.getOutputContents(CAP)) {
                researchData = ResearchManager.readResearchId(((Ingredient)CAP.of(stack.content)).m_43908_()[0]);
                if (researchData == null) continue;
                break;
            }
            if (researchData != null) {
                Collection<GTRecipe> possibleRecipes = ((GTRecipeType)researchData.getFirst()).getDataStickEntry((String)researchData.getSecond());
                ObjectOpenCustomHashSet cache = new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingItem());
                if (possibleRecipes != null) {
                    for (GTRecipe r : possibleRecipes) {
                        Content outputContent = r.getOutputContents(CAP).get(0);
                        ItemStack researchStack = ((Ingredient)CAP.of(outputContent.content)).m_43908_()[0];
                        if (cache.contains(researchStack)) continue;
                        cache.add(researchStack);
                        scannerPossibilities.add(ItemStackList.of(researchStack.m_255036_(1)));
                    }
                }
                scannerPossibilities.add((ItemEntryList)entryLists.get(0));
            }
        }
        if (scannerPossibilities != null && !scannerPossibilities.isEmpty()) {
            entryLists = scannerPossibilities;
        }
        while (entryLists.size() < recipe.recipeType.getMaxOutputs(CAP)) {
            entryLists.add(null);
        }
        return new ArrayList<Object>(entryLists);
    }

    @Override
    public Object createXEIContainer(List<?> contents) {
        return new CycleItemEntryHandler(contents);
    }

    @Override
    @NotNull
    public Widget createWidget() {
        SlotWidget slot = new SlotWidget();
        slot.initTemplate();
        return slot;
    }

    @Override
    @NotNull
    public Class<? extends Widget> getWidgetClass() {
        return SlotWidget.class;
    }

    @Override
    public void applyWidgetInfo(@NotNull Widget widget, int index, boolean isXEI, IO io,  @UnknownNullability(value="null when storage == null") GTRecipeTypeUI.RecipeHolder recipeHolder, @NotNull GTRecipeType recipeType, @UnknownNullability(value="null when content == null") GTRecipe recipe, @Nullable Content content, @Nullable Object storage, int recipeTier, int chanceTier) {
        if (widget instanceof SlotWidget) {
            SlotWidget slot = (SlotWidget)widget;
            if (storage instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable items = (IItemHandlerModifiable)storage;
                if (index >= 0 && index < items.getSlots()) {
                    slot.setHandlerSlot(items, index);
                    slot.setIngredientIO(io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT);
                    slot.setCanTakeItems(!isXEI);
                    slot.setCanPutItems(!isXEI && io.support(IO.IN));
                }
                if (isXEI && recipeType.isHasResearchSlot() && index == items.getSlots() && ConfigHolder.INSTANCE.machines.enableResearch) {
                    ResearchCondition condition = recipeHolder.conditions().stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
                    if (condition != null) {
                        ArrayList<ItemStack> dataItems = new ArrayList<ItemStack>();
                        for (ResearchData.ResearchEntry entry : condition.data) {
                            ItemStack dataStick = entry.getDataItem().m_41777_();
                            ResearchManager.writeResearchToNBT(dataStick.m_41784_(), entry.getResearchId(), recipeType);
                            dataItems.add(dataStick);
                        }
                        CycleItemStackHandler handler = new CycleItemStackHandler(List.of(dataItems));
                        slot.setHandlerSlot(handler, 0);
                        slot.setIngredientIO(IngredientIO.INPUT);
                        slot.setCanTakeItems(false);
                        slot.setCanPutItems(false);
                    }
                }
            }
            if (content != null) {
                float chance = (float)recipeType.getChanceFunction().getBoostedChance(content, recipeTier, chanceTier) / (float)content.maxChance;
                slot.setXEIChance(chance);
                slot.setOnAddedTooltips((w, tooltips) -> {
                    GTRecipeWidget.setConsumedChance(content, recipe.getChanceLogicForCapability(this, io, this.isTickSlot(index, io, recipe)), tooltips, recipeTier, chanceTier, recipeType.getChanceFunction());
                    Object patt26534$temp = this.of(content.content);
                    if (patt26534$temp instanceof IntProviderIngredient) {
                        IntProviderIngredient ingredient = (IntProviderIngredient)((Object)((Object)patt26534$temp));
                        countProvider = ingredient.getCountProvider();
                        tooltips.add(Component.m_237110_((String)"gtceu.gui.content.count_range", (Object[])new Object[]{countProvider.m_142739_(), countProvider.m_142737_()}).m_130940_(ChatFormatting.GOLD));
                    } else {
                        SizedIngredient sizedIngredient;
                        Ingredient patt27070$temp;
                        Object patt26969$temp = this.of(content.content);
                        if (patt26969$temp instanceof SizedIngredient && (patt27070$temp = (sizedIngredient = (SizedIngredient)((Object)((Object)patt26969$temp))).getInner()) instanceof IntProviderIngredient) {
                            IntProviderIngredient ingredient = (IntProviderIngredient)patt27070$temp;
                            countProvider = ingredient.getCountProvider();
                            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.count_range", (Object[])new Object[]{countProvider.m_142739_(), countProvider.m_142737_()}).m_130940_(ChatFormatting.GOLD));
                        }
                    }
                    if (this.isTickSlot(index, io, recipe)) {
                        tooltips.add(Component.m_237115_((String)"gtceu.gui.content.per_tick"));
                    }
                });
                if (io == IO.IN && (content.chance == 0 || this.of(content.content) instanceof IntCircuitIngredient)) {
                    slot.setIngredientIO(IngredientIO.CATALYST);
                }
            }
        }
    }

    private static ItemEntryList mapItem(Ingredient ingredient) {
        SizedIngredient sized;
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            int amount = sizedIngredient.getAmount();
            ItemEntryList mapped = ItemRecipeCapability.tryMapInner(sizedIngredient.getInner(), amount);
            if (mapped != null) {
                return mapped;
            }
        } else if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
            boolean amount = true;
            ItemEntryList mapped = ItemRecipeCapability.tryMapInner(intProvider.getInner(), 1);
            if (mapped != null) {
                return mapped;
            }
        } else {
            if (ingredient instanceof IntersectionIngredient) {
                IntersectionIngredient intersection = (IntersectionIngredient)ingredient;
                return ItemRecipeCapability.mapIntersection(intersection, -1);
            }
            ItemTagList tagList = ItemRecipeCapability.tryMapTag(ingredient, 1);
            if (tagList != null) {
                return tagList;
            }
        }
        ItemStackList stackList = new ItemStackList();
        boolean isIntProvider = ingredient instanceof IntProviderIngredient || ingredient instanceof SizedIngredient && (sized = (SizedIngredient)ingredient).getInner() instanceof IntProviderIngredient;
        UnaryOperator setCount = stack -> isIntProvider ? stack.m_255036_(1) : stack;
        Arrays.stream(ingredient.m_43908_()).map(setCount).forEach(stackList::add);
        return stackList;
    }

    @Nullable
    private static ItemEntryList tryMapInner(Ingredient inner, int amount) {
        if (inner instanceof IntersectionIngredient) {
            IntersectionIngredient intersection = (IntersectionIngredient)inner;
            return ItemRecipeCapability.mapIntersection(intersection, amount);
        }
        return ItemRecipeCapability.tryMapTag(inner, amount);
    }

    private static ItemEntryList mapIntersection(IntersectionIngredient intersection, int amount) {
        List<Ingredient> children = ((IntersectionIngredientAccessor)intersection).getChildren();
        if (children.isEmpty()) {
            return new ItemStackList();
        }
        ItemEntryList childList = ItemRecipeCapability.mapItem(children.get(0));
        ItemStackList stackList = new ItemStackList();
        for (ItemStack stack : childList.getStacks()) {
            if (!children.stream().skip(1L).allMatch(child -> child.test(stack))) continue;
            if (amount > 0) {
                stackList.add(stack.m_255036_(amount));
                continue;
            }
            stackList.add(stack.m_41777_());
        }
        return stackList;
    }

    @Nullable
    private static ItemTagList tryMapTag(Ingredient ingredient, int amount) {
        Ingredient.Value value;
        Ingredient.Value[] values = ((IngredientAccessor)ingredient).getValues();
        if (values.length > 0 && (value = values[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            return ItemTagList.of(((TagValueAccessor)tagValue).getTag(), amount, null);
        }
        return null;
    }

    @Override
    public Object2IntMap<Ingredient> makeChanceCache() {
        return new Object2IntOpenCustomHashMap((Hash.Strategy)IngredientEquality.IngredientHashStrategy.INSTANCE);
    }

    private static /* synthetic */ void lambda$convertToMapIngredient$0(List ingredients, TagKey tag) {
        ingredients.add(new MapItemTagIngredient((TagKey<Item>)tag));
    }

    public static interface ICustomParallel {
        public int limitParallel(GTRecipe var1, int var2);
    }
}

