/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.client.renderer.block.MaterialBlockRenderer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.lowdragmc.lowdraglib.Platform;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MaterialBlock
extends AppearanceBlock {
    public final TagPrefix tagPrefix;
    public final Material material;
    public static VoxelShape FRAME_COLLISION_BOX = Shapes.m_83048_((double)0.05, (double)0.0, (double)0.05, (double)0.95, (double)1.0, (double)0.95);

    public MaterialBlock(BlockBehaviour.Properties properties, TagPrefix tagPrefix, Material material, boolean registerModel) {
        super(properties);
        this.material = material;
        this.tagPrefix = tagPrefix;
        if (registerModel && Platform.isClient()) {
            MaterialBlockRenderer.create(this, tagPrefix.materialIconType(), material.getMaterialIconSet());
        }
    }

    public MaterialBlock(BlockBehaviour.Properties properties, TagPrefix tagPrefix, Material material) {
        this(properties, tagPrefix, material, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedColor() {
        return (state, reader, pos, tintIndex) -> {
            Block patt3439$temp = state.m_60734_();
            if (patt3439$temp instanceof MaterialBlock) {
                MaterialBlock block = (MaterialBlock)patt3439$temp;
                return block.material.getLayerARGB(tintIndex);
            }
            return -1;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.tagPrefix == TagPrefix.frameGt) {
            return FRAME_COLLISION_BOX;
        }
        return super.m_5939_(state, level, pos, context);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.m_186460_(currentPos, (Block)this, this.getDelayAfterPlace());
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_())) || pos.m_123342_() < level.m_141937_()) {
            return;
        }
        FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!(TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall)) {
            return;
        }
        if (random.m_188503_(16) == 0 && FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            double d = (double)pos.m_123341_() + random.m_188500_();
            double e = (double)pos.m_123342_() - 0.05;
            double f = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public String m_7705_() {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public MutableComponent m_49954_() {
        return this.tagPrefix.getLocalizedName(this.material);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.tagPrefix != TagPrefix.frameGt) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (stack.m_41720_() instanceof PipeBlockItem) {
            return this.replaceWithFramedPipe(level, pos, state, player, stack, hit) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        Set<GTToolType> types = ToolHelper.getToolTypes(stack);
        if (!types.isEmpty() && ToolHelper.canUse(stack) && types.contains(GTToolType.CROWBAR)) {
            return this.removeFrame(level, pos, player, stack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        MaterialBlock frameBlock = MaterialBlock.getFrameboxFromItem(stack);
        if (frameBlock == null) {
            return InteractionResult.PASS;
        }
        BlockPos.MutableBlockPos blockPos = pos.m_122032_();
        for (int i = 0; i < 32; ++i) {
            PipeBlockEntity pbe;
            BlockEntity te;
            Block block = level.m_8055_((BlockPos)blockPos).m_60734_();
            if (block instanceof MaterialBlock) {
                MaterialBlock matBlock = (MaterialBlock)block;
                if (matBlock.tagPrefix == TagPrefix.frameGt) {
                    blockPos.m_122173_(Direction.UP);
                    continue;
                }
            }
            if ((te = level.m_7702_((BlockPos)blockPos)) instanceof PipeBlockEntity && (pbe = (PipeBlockEntity)te).getFrameMaterial() != null) {
                blockPos.m_122173_(Direction.UP);
                continue;
            }
            if (MaterialBlock.m_49936_((BlockGetter)level, (BlockPos)blockPos.m_7495_())) {
                level.m_7731_((BlockPos)blockPos, frameBlock.m_49966_(), 3);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (te instanceof PipeBlockEntity && (pbe = (PipeBlockEntity)te).getFrameMaterial() == null) {
                pbe.setFrameMaterial(frameBlock.material);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static MaterialBlock getFrameboxFromItem(ItemStack stack) {
        BlockItem ib;
        Block block;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (block = (ib = (BlockItem)item).m_40614_()) instanceof MaterialBlock) {
            MaterialBlock matBlock = (MaterialBlock)block;
            return matBlock.tagPrefix == TagPrefix.frameGt ? matBlock : null;
        }
        return null;
    }

    public boolean removeFrame(Level level, BlockPos pos, Player player, ItemStack stack) {
        PipeBlockEntity pipeTile;
        Material mat;
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof PipeBlockEntity && (mat = (pipeTile = (PipeBlockEntity)te).getFrameMaterial()) != null) {
            pipeTile.setFrameMaterial(null);
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.m_5456_().m_7968_());
            ToolHelper.damageItem(stack, (LivingEntity)player);
            ToolHelper.playToolSound(GTToolType.CROWBAR, (ServerPlayer)player);
            return true;
        }
        return false;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        if (this.tagPrefix == TagPrefix.frameGt && useContext.m_43722_().m_41720_() instanceof PipeBlockItem && !useContext.m_43723_().m_6047_()) {
            return true;
        }
        return super.m_6864_(state, useContext);
    }

    public boolean replaceWithFramedPipe(Level level, BlockPos pos, BlockState state, Player player, ItemStack stackInHand, BlockHitResult hit) {
        PipeBlock pipeBlock = ((PipeBlockItem)stackInHand.m_41720_()).getBlock();
        if (((IPipeType)pipeBlock.pipeType).getThickness() < 1.0f) {
            PipeBlockItem itemBlock = (PipeBlockItem)stackInHand.m_41720_();
            BlockState pipeState = pipeBlock.m_49966_();
            BlockPlaceContext context = new BlockPlaceContext(level, player, InteractionHand.MAIN_HAND, stackInHand, hit);
            BlockState original = level.m_8055_(context.m_8083_());
            itemBlock.m_7429_(context, pipeState);
            IPipeNode pipeTile = pipeBlock.getPipeTile((BlockGetter)level, pos);
            if (!(pipeTile instanceof PipeBlockEntity)) {
                level.m_46597_(context.m_8083_(), original);
                return false;
            }
            PipeBlockEntity pipeBlockEntity = (PipeBlockEntity)pipeTile;
            pipeBlockEntity.setFrameMaterial(this.material);
            SoundType type = VanillaRecipeHelper.isMaterialWood(pipeTile.getFrameMaterial()) ? SoundType.f_56736_ : SoundType.f_56743_;
            level.m_5594_(player, pos, type.m_56777_(), SoundSource.BLOCKS, (type.m_56773_() + 1.0f) / 2.0f, type.m_56774_() * 0.8f);
            if (!player.m_7500_()) {
                stackInHand.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.tagPrefix == TagPrefix.frameGt && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double currentAccel = 0.15 * (livingEntity.m_20184_().f_82480_ < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = 0.9 * (livingEntity.m_20069_() ? 0.4 : 1.0);
            Vec3 deltaMovement = livingEntity.m_20184_();
            livingEntity.m_183634_();
            float f = 0.15f;
            double d0 = Mth.m_14008_((double)deltaMovement.f_82479_, (double)(-f), (double)f);
            double d1 = Mth.m_14008_((double)deltaMovement.f_82481_, (double)(-f), (double)f);
            double d2 = Math.max(deltaMovement.f_82480_, (double)(-f));
            if (d2 < 0.0 && !livingEntity.m_146900_().isScaffolding(livingEntity) && livingEntity.m_5791_() && livingEntity instanceof Player) {
                d2 = Math.min(deltaMovement.f_82480_ + currentAccel, 0.0);
            }
            if (livingEntity.f_19862_) {
                d2 = 0.3;
            }
            deltaMovement = new Vec3(d0, d2, d1);
            entity.m_20256_(deltaMovement);
        }
    }
}

