/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.registries.BloodMagicEntityTypes;
import wayoftime.bloodmagic.common.tile.TileExplosiveCharge;

public class EntityShapedCharge
extends ThrowableProjectile {
    private static final EntityDataAccessor<BlockState> ITEMSTACK_DATA = SynchedEntityData.m_135353_(EntityShapedCharge.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private AnointmentHolder holder;

    public EntityShapedCharge(EntityType<EntityShapedCharge> p_i50159_1_, Level p_i50159_2_) {
        super(p_i50159_1_, p_i50159_2_);
    }

    public EntityShapedCharge(Level worldIn, Block block, LivingEntity throwerIn) {
        super(BloodMagicEntityTypes.SHAPED_CHARGE.getEntityType(), throwerIn, worldIn);
        this.setFallTile(block.m_49966_());
    }

    public EntityShapedCharge(Level worldIn, Block block, double x, double y, double z) {
        super(BloodMagicEntityTypes.SHAPED_CHARGE.getEntityType(), x, y, z, worldIn);
        this.setFallTile(block.m_49966_());
    }

    public void setAnointmentHolder(AnointmentHolder holder) {
        this.holder = holder;
    }

    public void setFallTile(BlockState state) {
        this.f_19804_.m_135381_(ITEMSTACK_DATA, (Object)state);
    }

    public void m_8119_() {
        super.m_8119_();
        HitResult raytraceresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            Direction faceHit = ((BlockHitResult)raytraceresult).m_82434_();
            BlockPos blockpos = ((BlockHitResult)raytraceresult).m_82425_().m_121945_(((BlockHitResult)raytraceresult).m_82434_());
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            BlockState fallTile = this.getBlockState();
            if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_13076_) || blockstate.m_278721_() || blockstate.m_247087_()) {
                this.m_20193_().m_46597_(blockpos, (BlockState)fallTile.m_61124_(BlockShapedExplosive.ATTACHED, (Comparable)faceHit));
                BlockEntity tile = this.m_20193_().m_7702_(blockpos);
                if (tile instanceof TileExplosiveCharge) {
                    ((TileExplosiveCharge)tile).setAnointmentHolder(this.holder);
                }
                this.m_6089_();
            } else {
                this.m_19998_((ItemLike)fallTile.m_60734_());
                this.m_6089_();
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.getBlockState()));
        if (this.holder != null) {
            compound.m_128365_("holder", (Tag)this.holder.serialize());
        }
    }

    protected void m_7378_(CompoundTag compound) {
        BlockState fallTile = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("BlockState"));
        this.setFallTile(fallTile);
        if (compound.m_128441_("holder")) {
            this.holder = AnointmentHolder.fromNBT(compound.m_128469_("holder"));
        }
        if (fallTile.m_60795_()) {
            fallTile = ((Block)BloodMagicBlocks.SHAPED_CHARGE.get()).m_49966_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEMSTACK_DATA, (Object)Blocks.f_49992_.m_49966_());
    }

    public BlockState getBlockState() {
        return (BlockState)this.f_19804_.m_135370_(ITEMSTACK_DATA);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Level getWorldObj() {
        return this.m_9236_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

