/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWillConduit;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.base.TileTicking;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class TileDemonPylon
extends TileTicking
implements IDemonWillConduit {
    public final int maxWill = 100;
    public final double drainRate = 1.0;
    public DemonWillHolder holder = new DemonWillHolder();

    public TileDemonPylon(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileDemonPylon(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.DEMON_PYLON_TYPE.get(), pos, state);
    }

    @Override
    public void onUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            double currentAmount = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, type);
            for (int i = 0; i < 4; ++i) {
                Direction side = Direction.m_122407_((int)i);
                BlockPos offsetPos = this.f_58858_.m_5484_(side, 16);
                double sideAmount = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), offsetPos, type);
                if (!(sideAmount > currentAmount)) continue;
                double drainAmount = Math.min((sideAmount - currentAmount) / 2.0, 1.0);
                double drain = WorldDemonWillHandler.drainWill(this.m_58904_(), offsetPos, type, drainAmount, true);
                WorldDemonWillHandler.fillWill(this.m_58904_(), this.f_58858_, type, drain, true);
            }
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.holder.readFromNBT(tag, "Will");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        this.holder.writeToNBT(tag, "Will");
        return tag;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        if (!doFill) {
            return Math.min(100.0 - this.holder.getWill(type), amount);
        }
        return this.holder.addWill(type, amount, 100.0);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        double drained = amount;
        double current = this.holder.getWill(type);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            return this.holder.drainWill(type, amount);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return this.holder.getWill(type);
    }
}

