/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.crafting.Ingredient;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.potion.BloodMagicPotions;

public class PotionIncreaseLengthRecipeBuilder
extends BloodMagicRecipeBuilder<PotionIncreaseLengthRecipeBuilder> {
    private final List<Ingredient> input;
    private final MobEffect outputEffect;
    private final double lengthDurationMod;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionIncreaseLengthRecipeBuilder(List<Ingredient> input, MobEffect outputEffect, double lengthDurationMod, int syphon, int ticks, int minimumTier) {
        super(PotionIncreaseLengthRecipeBuilder.bmSerializer("flask_potionlength"));
        this.outputEffect = outputEffect;
        this.lengthDurationMod = lengthDurationMod;
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionIncreaseLengthRecipeBuilder potionIncreaseLength(MobEffect outputEffect, double lengthDurationMod, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionIncreaseLengthRecipeBuilder(inputList, outputEffect, lengthDurationMod, syphon, ticks, minimumTier);
    }

    public PotionIncreaseLengthRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    @Override
    protected PotionIncreaseLengthRecipeResult getResult(ResourceLocation id) {
        return new PotionIncreaseLengthRecipeResult(id);
    }

    public class PotionIncreaseLengthRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionIncreaseLengthRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            if (PotionIncreaseLengthRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : PotionIncreaseLengthRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.m_43942_();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.addProperty("syphon", (Number)PotionIncreaseLengthRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionIncreaseLengthRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionIncreaseLengthRecipeBuilder.this.minimumTier);
            json.addProperty("effect", BloodMagicPotions.getRegistryName(PotionIncreaseLengthRecipeBuilder.this.outputEffect).toString());
            json.addProperty("lengthDurMod", (Number)PotionIncreaseLengthRecipeBuilder.this.lengthDurationMod);
        }
    }
}

