/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.component;

import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;

public class SideConfiguration
implements INBTSerializable<CompoundTag> {
    private static final int MAX_OUTPUTS = 4;
    private final EnumMap<Direction, TypeEnums.IO_SETTING> config = new EnumMap(Direction.class);
    private final Direction facing;
    private final Direction bottom;

    public SideConfiguration(BlockState state) {
        this.facing = (Direction)state.m_61143_((Property)MeterBlock.FACING);
        this.bottom = (Direction)state.m_61143_((Property)MeterBlock.BOTTOM);
        for (Direction direction : Direction.values()) {
            this.config.put(direction, TypeEnums.IO_SETTING.OFF);
        }
    }

    public TypeEnums.IO_SETTING get(Direction direction) {
        return this.config.get(direction);
    }

    public TypeEnums.IO_SETTING get(TypeEnums.BLOCK_SIDE side) {
        return this.config.get(this.getDirectionFromSide(side));
    }

    public Direction getDirectionFromSide(TypeEnums.BLOCK_SIDE side) {
        return this.facing == this.bottom ? this.horizontalConversion(side) : this.verticalConversion(side);
    }

    public void set(TypeEnums.BLOCK_SIDE side, TypeEnums.IO_SETTING setting) {
        this.config.put(this.getDirectionFromSide(side), setting);
    }

    public boolean hasInput() {
        return this.config.containsValue((Object)TypeEnums.IO_SETTING.IN);
    }

    public boolean hasOutput() {
        return this.config.containsValue((Object)TypeEnums.IO_SETTING.OUT);
    }

    public boolean hasMaxOutputs() {
        return this.config.values().stream().filter(setting -> setting == TypeEnums.IO_SETTING.OUT).count() == 4L;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Direction direction : Direction.values()) {
            nbt.m_128405_(direction.toString(), this.config.get(direction).ordinal());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Direction direction : Direction.values()) {
            this.config.put(direction, TypeEnums.IO_SETTING.values()[nbt.m_128451_(direction.toString())]);
        }
    }

    public Map<String, String> asStringMap() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<Direction, TypeEnums.IO_SETTING> entry : this.config.entrySet()) {
            stringMap.put(entry.getKey().m_122433_(), entry.getValue().name());
        }
        return stringMap;
    }

    private Direction horizontalConversion(TypeEnums.BLOCK_SIDE side) {
        return switch (side) {
            case TypeEnums.BLOCK_SIDE.TOP -> Direction.UP;
            case TypeEnums.BLOCK_SIDE.BOTTOM -> Direction.DOWN;
            case TypeEnums.BLOCK_SIDE.LEFT -> this.facing.m_122427_();
            case TypeEnums.BLOCK_SIDE.RIGHT -> this.facing.m_122428_();
            case TypeEnums.BLOCK_SIDE.BACK -> this.facing.m_122424_();
            default -> this.facing;
        };
    }

    private Direction verticalConversion(TypeEnums.BLOCK_SIDE side) {
        return switch (side) {
            case TypeEnums.BLOCK_SIDE.TOP -> this.bottom.m_122424_();
            case TypeEnums.BLOCK_SIDE.BOTTOM -> this.bottom;
            case TypeEnums.BLOCK_SIDE.LEFT -> {
                if (this.facing == Direction.UP) {
                    yield this.bottom.m_122427_();
                }
                yield this.bottom.m_122428_();
            }
            case TypeEnums.BLOCK_SIDE.RIGHT -> {
                if (this.facing == Direction.UP) {
                    yield this.bottom.m_122428_();
                }
                yield this.bottom.m_122427_();
            }
            case TypeEnums.BLOCK_SIDE.BACK -> this.facing.m_122424_();
            default -> this.facing;
        };
    }
}

