/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.client.ModClientForge;
import tfar.dankstorage.command.DankCommands;
import tfar.dankstorage.datagen.ModDatagen;
import tfar.dankstorage.event.ForgeClientEvents;
import tfar.dankstorage.menu.AbstractDankMenu;
import tfar.dankstorage.menu.CustomSync;

@Mod(value="dankstorage")
public class DankStorageForge {
    public static final Logger LOGGER = LogManager.getLogger((String)"dankstorage");
    public static Map<Registry<?>, List<Pair<ResourceLocation, Supplier<?>>>> registerLater = new HashMap();
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public DankStorageForge() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::containerEvent);
        bus.addListener(ModDatagen::setupDataGenerator);
        bus.addListener(this::registerObjs);
        bus.addListener(this::onInitialize);
        if (FMLEnvironment.dist.isClient()) {
            bus.addListener(this::onInitializeClient);
            bus.addListener(ModClientForge::keybinds);
            bus.addListener(ModClientForge::clientTool);
            bus.addListener(ForgeClientEvents::renderStack);
        }
        DankStorage.init();
    }

    public void registerObjs(RegisterEvent event) {
        for (Map.Entry<Registry<?>, List<Pair<ResourceLocation, Supplier<?>>>> entry : registerLater.entrySet()) {
            Registry<?> registry = entry.getKey();
            List<Pair<ResourceLocation, Supplier<?>>> toRegister = entry.getValue();
            for (Pair<ResourceLocation, Supplier<?>> pair : toRegister) {
                event.register(registry.m_123023_(), (ResourceLocation)pair.getLeft(), (Supplier)pair.getValue());
            }
        }
    }

    public void onInitialize(FMLCommonSetupEvent e) {
        registerLater.clear();
    }

    public void onInitializeClient(FMLClientSetupEvent e) {
        ModClientForge.client();
    }

    public void onServerStarted(ServerStartedEvent e) {
        DankStorage.onServerStart(e.getServer());
    }

    public void onServerStopped(ServerStoppedEvent e) {
        DankStorage.onServerShutDown(e.getServer());
    }

    public void registerCommands(RegisterCommandsEvent e) {
        DankCommands.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    private void containerEvent(PlayerContainerEvent.Open e) {
        AbstractContainerMenu abstractContainerMenu = e.getContainer();
        if (abstractContainerMenu instanceof AbstractDankMenu) {
            AbstractDankMenu dankMenu = (AbstractDankMenu)abstractContainerMenu;
            dankMenu.m_150416_(new CustomSync((ServerPlayer)e.getEntity()));
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (ServerConfig)specPair2.getLeft();
    }

    public static class ClientConfig {
        public static ForgeConfigSpec.BooleanValue preview;
        public static ForgeConfigSpec.IntValue preview_x;
        public static ForgeConfigSpec.IntValue preview_y;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            preview = builder.comment("Whether to display the preview of the item in the dank, disable if you have optifine").define("preview", true);
            preview_x = builder.comment("X position of preview").defineInRange("preview_x", -140, -10000, 10000);
            preview_y = builder.comment("Y position of preview").defineInRange("preview_y", -25, -10000, 10000);
            builder.pop();
        }
    }

    public static class ServerConfig {
        public static ForgeConfigSpec.IntValue stacklimit1;
        public static ForgeConfigSpec.IntValue stacklimit2;
        public static ForgeConfigSpec.IntValue stacklimit3;
        public static ForgeConfigSpec.IntValue stacklimit4;
        public static ForgeConfigSpec.IntValue stacklimit5;
        public static ForgeConfigSpec.IntValue stacklimit6;
        public static ForgeConfigSpec.IntValue stacklimit7;
        public static ForgeConfigSpec.ConfigValue<List<String>> convertible_tags;
        public static final List<String> defaults;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            stacklimit1 = builder.comment("Stack limit of first dank storage").defineInRange("stacklimit1", 256, 1, Integer.MAX_VALUE);
            stacklimit2 = builder.comment("Stack limit of second dank storage").defineInRange("stacklimit2", 1024, 1, Integer.MAX_VALUE);
            stacklimit3 = builder.comment("Stack limit of third dank storage").defineInRange("stacklimit3", 4096, 1, Integer.MAX_VALUE);
            stacklimit4 = builder.comment("Stack limit of fourth dank storage").defineInRange("stacklimit4", 16384, 1, Integer.MAX_VALUE);
            stacklimit5 = builder.comment("Stack limit of fifth dank storage").defineInRange("stacklimit5", 65536, 1, Integer.MAX_VALUE);
            stacklimit6 = builder.comment("Stack limit of sixth dank storage").defineInRange("stacklimit6", 262144, 1, Integer.MAX_VALUE);
            stacklimit7 = builder.comment("Stack limit of seventh dank storage").defineInRange("stacklimit7", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            convertible_tags = builder.comment("Tags that are eligible for conversion, input as a list of resourcelocation, eg 'forge:ingots/iron'").define("convertible tags", defaults);
            builder.pop();
        }

        static {
            defaults = Lists.newArrayList((Object[])new String[]{"forge:ingots/iron", "forge:ingots/gold", "forge:ores/coal", "forge:ores/diamond", "forge:ores/emerald", "forge:ores/gold", "forge:ores/iron", "forge:ores/lapis", "forge:ores/redstone", "forge:gems/amethyst", "forge:gems/peridot", "forge:gems/ruby", "forge:ingots/copper", "forge:ingots/lead", "forge:ingots/nickel", "forge:ingots/silver", "forge:ingots/tin", "forge:ores/copper", "forge:ores/lead", "forge:ores/ruby", "forge:ores/silver", "forge:ores/tin"});
        }
    }
}

