/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.FluidCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ItemCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.render.CraftingPreviewElementDrawers;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.network.grid.GridCraftingStartRequestMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPreviewScreen
extends BaseScreen<AbstractContainerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/crafting_preview.png");
    private static final int VISIBLE_ROWS = 5;
    private final List<ICraftingPreviewElement> elements;
    private final Screen parent;
    private final ScrollbarWidget scrollbar;
    private final UUID id;
    private final int quantity;
    private final boolean fluids;
    private final IElementDrawers drawers = new CraftingPreviewElementDrawers(this);
    private ItemStack hoveringStack;
    private FluidStack hoveringFluid;

    public CraftingPreviewScreen(Screen parent, List<ICraftingPreviewElement> elements, UUID id, int quantity, boolean fluids, Component title, Inventory inventory) {
        super(new AbstractContainerMenu(null, 0){

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(@Nonnull Player player) {
                return false;
            }
        }, 254, 201, inventory, title);
        this.elements = new ArrayList<ICraftingPreviewElement>(elements);
        this.parent = parent;
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
        this.scrollbar = new ScrollbarWidget(this, 235, 20, 12, 149);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addButton(x + 55, y + 201 - 20 - 7, 50, 20, (Component)Component.m_237115_((String)"gui.cancel"), true, true, btn -> this.close());
        Button startButton = this.addButton(x + 129, y + 201 - 20 - 7, 50, 20, (Component)Component.m_237115_((String)"misc.refinedstorage.start"), true, true, btn -> this.startRequest());
        startButton.f_93623_ = this.elements.stream().noneMatch(ICraftingPreviewElement::doesDisableTaskStarting);
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 5);
        this.scrollbar.setMaxOffset(this.getRows() - 5);
    }

    @Nullable
    private ErrorCraftingPreviewElement getError() {
        if (this.elements.size() == 1 && this.elements.get(0) instanceof ErrorCraftingPreviewElement) {
            return (ErrorCraftingPreviewElement)this.elements.get(0);
        }
        return null;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (this.getError() != null) {
            graphics.m_280509_(x + 7, y + 20, x + 228, y + 169, -2368549);
        }
        this.scrollbar.render(graphics);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.renderString(graphics, 7, 7, this.f_96539_.getString());
        int x = 7;
        int y = 15;
        float scale = Minecraft.m_91087_().m_91390_() ? 1.0f : 0.5f;
        ErrorCraftingPreviewElement error = this.getError();
        if (error != null) {
            this.renderError(graphics, x, y, scale, error);
        } else {
            this.renderPreview(graphics, mouseX, mouseY, x, y);
        }
    }

    private void renderPreview(GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
        Lighting.m_84931_();
        RenderSystem.enableDepthTest();
        this.hoveringStack = null;
        this.hoveringFluid = null;
        for (int i = 0; i < 15; ++i) {
            if (slot < this.elements.size()) {
                this.renderElement(graphics, mouseX, mouseY, x, y, this.elements.get(slot));
            }
            if ((i + 1) % 3 == 0) {
                x = 7;
                y += 30;
            } else {
                x += 74;
            }
            ++slot;
        }
    }

    private void renderElement(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, ICraftingPreviewElement element) {
        element.draw(graphics, x, y + 5, this.drawers);
        if (RenderUtils.inBounds(x + 5, y + 7, 16, 16, mouseX, mouseY)) {
            ItemStack itemStack = this.hoveringStack = element instanceof ItemCraftingPreviewElement ? ((ItemCraftingPreviewElement)element).getStack() : null;
            if (this.hoveringStack == null) {
                this.hoveringFluid = element instanceof FluidCraftingPreviewElement ? ((FluidCraftingPreviewElement)element).getStack() : null;
            }
        }
    }

    private void renderError(GuiGraphics graphics, int x, int y, float scale, ErrorCraftingPreviewElement errorElement) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 11, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error", (Object[])new Object[0]));
        switch (errorElement.getType()) {
            case RECURSIVE: {
                this.renderRecursiveError(graphics, x, y, scale, errorElement.getRecursedPattern());
                break;
            }
            case TOO_COMPLEX: {
                this.renderTooComplexError(graphics, x, y, scale);
                break;
            }
        }
        poseStack.m_85849_();
    }

    private void renderTooComplexError(GuiGraphics graphics, int x, int y, float scale) {
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error.too_complex.0", (Object[])new Object[0]));
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error.too_complex.1", (Object[])new Object[0]));
    }

    private void renderRecursiveError(GuiGraphics graphics, int x, int y, float scale, ItemStack recursedPattern) {
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error.recursive.0", (Object[])new Object[0]));
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error.recursive.1", (Object[])new Object[0]));
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 41, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error.recursive.2", (Object[])new Object[0]));
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 51, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error.recursive.3", (Object[])new Object[0]));
        this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 61, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.error.recursive.4", (Object[])new Object[0]));
        ICraftingPattern pattern = PatternItem.fromCache((Level)this.parent.getMinecraft().f_91073_, recursedPattern);
        int yy = 83;
        for (ItemStack output : pattern.getOutputs()) {
            if (output == null) continue;
            this.renderString(graphics, RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy + 6, scale), output.m_41786_().getString());
            Lighting.m_84931_();
            RenderSystem.enableDepthTest();
            this.renderItem(graphics, x + 5, yy, output);
            yy += 17;
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.hoveringStack != null) {
            this.renderTooltip(graphics, this.hoveringStack, mouseX, mouseY, this.hoveringStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)));
        } else if (this.hoveringFluid != null) {
            this.renderTooltip(graphics, mouseX, mouseY, this.hoveringFluid.getDisplayName().getString());
        }
    }

    public void m_94757_(double mx, double my) {
        this.scrollbar.m_94757_(mx, my);
        super.m_94757_(mx, my);
    }

    public boolean m_6375_(double mx, double my, int button) {
        return this.scrollbar.m_6375_(mx, my, button) || super.m_6375_(mx, my, button);
    }

    public boolean m_6348_(double mx, double my, int button) {
        return this.scrollbar.m_6348_(mx, my, button) || super.m_6348_(mx, my, button);
    }

    public boolean m_6050_(double x, double y, double delta) {
        return this.scrollbar.m_6050_(x, y, delta) || super.m_6050_(x, y, delta);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 257 || key == 335) {
            this.startRequest();
            return true;
        }
        if (key == 256) {
            this.close();
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    private void startRequest() {
        RS.NETWORK_HANDLER.sendToServer(new GridCraftingStartRequestMessage(this.id, this.quantity, this.fluids));
        this.close();
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.elements.size() / 3.0f));
    }

    private void close() {
        this.f_96541_.m_91152_(this.parent);
    }
}

