/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.emi;

import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.klikli_dev.occultism.integration.BoundBookRecipeMaker;
import com.klikli_dev.occultism.integration.emi.recipes.CrushingRecipeCategory;
import com.klikli_dev.occultism.integration.emi.recipes.MinerRecipeCategory;
import com.klikli_dev.occultism.integration.emi.recipes.RitualRecipeCategory;
import com.klikli_dev.occultism.integration.emi.recipes.SpiritFireRecipeCategory;
import com.klikli_dev.occultism.integration.emi.render.SpiritRenderable;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@EmiEntrypoint
public class OccultismEmiPlugin
implements EmiPlugin {
    public static final EmiStack SPIRIT_FIRE = EmiStack.of((ItemLike)((ItemLike)OccultismItems.SPIRIT_FIRE.get()));
    public static final EmiStack DIMENSIONAL_MINESHAFT = EmiStack.of((ItemLike)((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()));
    public static final EmiStack GOLDEN_SACRIFICIAL_BOWL = EmiStack.of((ItemLike)((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()));
    public static final ResourceLocation EMI_WIDGETS = new ResourceLocation("occultism", "textures/gui/emi/widgets.png");
    public static final EmiRecipeCategory SPIRIT_FIRE_CATEGORY = new EmiRecipeCategory(new ResourceLocation("occultism", "spirit_fire"), (EmiRenderable)SPIRIT_FIRE, (EmiRenderable)new EmiTexture(EMI_WIDGETS, 0, 0, 16, 16));
    public static final EmiRecipeCategory CRUSHING_CATEGORY = new EmiRecipeCategory(new ResourceLocation("occultism", "crushing"), new SpiritRenderable((EntityType)OccultismEntities.FOLIOT.get()), (EmiRenderable)new EmiTexture(EMI_WIDGETS, 32, 0, 16, 16));
    public static final EmiRecipeCategory MINER_CATEGORY = new EmiRecipeCategory(new ResourceLocation("occultism", "miner"), (EmiRenderable)DIMENSIONAL_MINESHAFT, (EmiRenderable)new EmiTexture(EMI_WIDGETS, 48, 0, 16, 16));
    public static final EmiRecipeCategory RITUAL_CATEGORY = new EmiRecipeCategory(new ResourceLocation("occultism", "ritual"), (EmiRenderable)GOLDEN_SACRIFICIAL_BOWL, (EmiRenderable)new EmiTexture(EMI_WIDGETS, 64, 0, 16, 16));

    public void initialize(EmiInitRegistry registry) {
        super.initialize(registry);
    }

    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addCategory(SPIRIT_FIRE_CATEGORY);
        emiRegistry.addWorkstation(SPIRIT_FIRE_CATEGORY, (EmiIngredient)SPIRIT_FIRE);
        emiRegistry.addCategory(CRUSHING_CATEGORY);
        emiRegistry.addWorkstation(CRUSHING_CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("occultism", "ritual_dummy/summon_foliot_crusher"))))));
        emiRegistry.addWorkstation(CRUSHING_CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("occultism", "ritual_dummy/summon_djinni_crusher"))))));
        emiRegistry.addWorkstation(CRUSHING_CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("occultism", "ritual_dummy/summon_afrit_crusher"))))));
        emiRegistry.addWorkstation(CRUSHING_CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("occultism", "ritual_dummy/summon_marid_crusher"))))));
        emiRegistry.addCategory(MINER_CATEGORY);
        emiRegistry.addWorkstation(MINER_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get())));
        emiRegistry.addCategory(RITUAL_CATEGORY);
        emiRegistry.addWorkstation(RITUAL_CATEGORY, (EmiIngredient)GOLDEN_SACRIFICIAL_BOWL);
        RecipeManager manager = emiRegistry.getRecipeManager();
        for (SpiritFireRecipe spiritFireRecipe : manager.m_44013_((RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new SpiritFireRecipeCategory(spiritFireRecipe));
        }
        for (CrushingRecipe crushingRecipe : manager.m_44013_((RecipeType)OccultismRecipes.CRUSHING_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new CrushingRecipeCategory(crushingRecipe));
        }
        for (MinerRecipe minerRecipe : manager.m_44013_((RecipeType)OccultismRecipes.MINER_TYPE.get())) {
            if (((Ingredient)minerRecipe.m_7527_().get((int)0)).f_43902_.length != 1 || !(((Ingredient)minerRecipe.m_7527_().get((int)0)).f_43902_[0] instanceof Ingredient.TagValue)) continue;
            TagKey tag = ((Ingredient.TagValue)((Ingredient)minerRecipe.m_7527_().get((int)0)).f_43902_[0]).f_43959_;
            if (!MinerRecipeCategory.totalWeights.containsKey(tag)) {
                MinerRecipeCategory.totalWeights.put((TagKey<Item>)tag, 0L);
            }
            MinerRecipeCategory.totalWeights.put((TagKey<Item>)tag, MinerRecipeCategory.totalWeights.get(tag) + (long)minerRecipe.getWeightedOutput().m_142631_().m_146281_());
        }
        for (MinerRecipe minerRecipe : manager.m_44013_((RecipeType)OccultismRecipes.MINER_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new MinerRecipeCategory(minerRecipe));
        }
        for (RitualRecipe ritualRecipe : manager.m_44013_((RecipeType)OccultismRecipes.RITUAL_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new RitualRecipeCategory(ritualRecipe));
        }
        for (CraftingRecipe craftingRecipe : BoundBookRecipeMaker.createRecipes()) {
            List<EmiIngredient> ingredients = craftingRecipe.m_7527_().stream().map(EmiIngredient::of).toList();
            emiRegistry.addRecipe((EmiRecipe)new EmiCraftingRecipe(ingredients, EmiStack.of((ItemStack)craftingRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_)), craftingRecipe.m_6423_(), true));
        }
    }
}

