/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.forge;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class BlockSetInternalImpl {
    private static final Map<ResourceKey<? extends Registry<?>>, Map<String, List<Runnable>>> LATE_REGISTRATION_QUEUE = new ConcurrentHashMap();
    private static boolean hasFilledBlockSets = false;
    private static boolean hasRegisteredDynamic = false;

    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, Registry<E> registry) {
        if (registry == BuiltInRegistries.f_256975_) {
            BlockSetInternalImpl.addEvent(ForgeRegistries.BLOCKS, registrationFunction, blockType);
        } else if (registry == BuiltInRegistries.f_257033_) {
            BlockSetInternalImpl.addEvent(ForgeRegistries.ITEMS, registrationFunction, blockType);
        } else {
            if (registry == BuiltInRegistries.f_257020_ || registry == BuiltInRegistries.f_256894_) {
                throw new IllegalArgumentException("Fluid and Sound Events registry not supported here");
            }
            BlockSetInternalImpl.getOrAddQueue(Registries.f_256922_);
            RegHelper.registerInBatch(registry, e -> registrationFunction.accept((Registrator)e, BlockSetAPI.getBlockSet(blockType).getValues()));
        }
    }

    public static <T extends BlockType, E> void addEvent(IForgeRegistry<E> reg, BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType) {
        List<Runnable> registrationQueues = BlockSetInternalImpl.getOrAddQueue(reg.getRegistryKey());
        Consumer<RegisterEvent> eventConsumer = e -> {
            if (e.getRegistryKey().equals((Object)reg.getRegistryKey())) {
                Runnable lateRegistration = () -> {
                    IForgeRegistry registry = e.getForgeRegistry();
                    if (registry instanceof ForgeRegistry) {
                        ForgeRegistry fr = (ForgeRegistry)registry;
                        boolean frozen = fr.isLocked();
                        fr.unfreeze();
                        registrationFunction.accept((arg_0, arg_1) -> ((IForgeRegistry)registry).register(arg_0, arg_1), BlockSetAPI.getBlockSet(blockType).getValues());
                        if (frozen) {
                            fr.freeze();
                        }
                    }
                };
                registrationQueues.add(lateRegistration);
            }
        };
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventPriority.HIGHEST, eventConsumer);
    }

    @NotNull
    private static <R> List<Runnable> getOrAddQueue(ResourceKey<Registry<R>> reg) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        String modId = ModLoadingContext.get().getActiveContainer().getModId();
        if (LATE_REGISTRATION_QUEUE.isEmpty()) {
            bus.addListener(EventPriority.HIGHEST, BlockSetInternalImpl::registerLateBlockAndItems);
        }
        return LATE_REGISTRATION_QUEUE.computeIfAbsent(reg, r -> new LinkedHashMap()).computeIfAbsent(modId, r -> new ArrayList());
    }

    protected static void registerLateBlockAndItems(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.ATTRIBUTES.getRegistryKey()) && !hasFilledBlockSets) {
            BlockSetInternal.initializeBlockSets();
            hasFilledBlockSets = true;
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.ENTITY_TYPES.getRegistryKey()) && !hasRegisteredDynamic) {
            Map<String, List<Runnable>> itemQueue;
            Map<ResourceKey<Registry<?>>, Map<String, List<Runnable>>> registrationQueues;
            Map<String, List<Runnable>> blockQueue;
            hasRegisteredDynamic = true;
            BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
            if (!hasFilledBlockSets) {
                BlockSetInternal.initializeBlockSets();
                hasFilledBlockSets = true;
            }
            if ((blockQueue = (registrationQueues = LATE_REGISTRATION_QUEUE).remove(ForgeRegistries.BLOCKS.getRegistryKey())) != null) {
                for (List<Runnable> list : blockQueue.values()) {
                    list.forEach(Runnable::run);
                }
            }
            if ((itemQueue = registrationQueues.remove(ForgeRegistries.ITEMS.getRegistryKey())) != null) {
                for (List list : itemQueue.values()) {
                    list.forEach(Runnable::run);
                }
            }
            for (Map map : registrationQueues.values()) {
                for (List list : map.values()) {
                    list.forEach(Runnable::run);
                }
            }
            LATE_REGISTRATION_QUEUE.clear();
        }
    }

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }
}

