/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemHandlerItemStackIterator;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;

public abstract class SlotlessItemHandlerWrapper
implements ISlotlessItemHandler {
    protected final IItemHandler itemHandler;

    public SlotlessItemHandlerWrapper(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    protected abstract PrimitiveIterator.OfInt getNonFullSlotsWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract PrimitiveIterator.OfInt getNonEmptySlotsWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract PrimitiveIterator.OfInt getSlotsWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract PrimitiveIterator.OfInt getEmptySlots();

    protected abstract PrimitiveIterator.OfInt getNonEmptySlots();

    @Override
    public Iterator<ItemStack> getItems() {
        return new ItemHandlerItemStackIterator(this.itemHandler);
    }

    @Override
    public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
        return Iterators.transform((Iterator)this.getSlotsWithItemStack(stack, matchFlags), (Function)new Function<Integer, ItemStack>(){

            @Nullable
            public ItemStack apply(@Nullable Integer input) {
                return SlotlessItemHandlerWrapper.this.itemHandler.getStackInSlot(input.intValue());
            }
        });
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        int slot;
        IntArrayList applicableSlots;
        ItemStack stackSimulate = stack;
        PrimitiveIterator.OfInt itNonFull = this.getNonFullSlotsWithItemStack(stackSimulate, 5);
        IntArrayList intArrayList = applicableSlots = simulate ? null : new IntArrayList();
        while (itNonFull.hasNext() && !stackSimulate.m_41619_()) {
            int slot2 = itNonFull.nextInt();
            int countPre = stackSimulate.m_41613_();
            stackSimulate = this.itemHandler.insertItem(slot2, stackSimulate, true);
            int countPost = stackSimulate.m_41613_();
            if (simulate || countPre == countPost) continue;
            applicableSlots.add(slot2);
        }
        if (!stackSimulate.m_41619_()) {
            PrimitiveIterator.OfInt itEmpty = this.getEmptySlots();
            while (itEmpty.hasNext() && !stackSimulate.m_41619_()) {
                slot = itEmpty.nextInt();
                int countPre = stackSimulate.m_41613_();
                stackSimulate = this.itemHandler.insertItem(slot, stackSimulate, true);
                int countPost = stackSimulate.m_41613_();
                if (simulate || countPre == countPost) continue;
                applicableSlots.add(slot);
            }
        }
        if (!simulate) {
            IntListIterator it = applicableSlots.iterator();
            while (it.hasNext() && !stack.m_41619_()) {
                slot = it.nextInt();
                stack = this.itemHandler.insertItem(slot, stack, false);
            }
            return stack;
        }
        return stackSimulate;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int amount, boolean simulate) {
        int amountSimulate = amount;
        PrimitiveIterator.OfInt itSimulated = this.getNonEmptySlots();
        IntArrayList applicableSlots = simulate ? null : new IntArrayList();
        ItemStack extractedAcc = ItemStack.f_41583_;
        while (itSimulated.hasNext() && amountSimulate > 0) {
            int slot = itSimulated.nextInt();
            ItemStack extracted = this.itemHandler.extractItem(slot, amountSimulate, true);
            if (extracted.m_41619_()) continue;
            if (extractedAcc.m_41619_()) {
                extractedAcc = extracted.m_41777_();
                amountSimulate -= extracted.m_41613_();
                if (simulate) continue;
                applicableSlots.add(slot);
                continue;
            }
            if (!ItemMatch.areItemStacksEqual(extracted, extractedAcc, 5)) continue;
            amountSimulate -= extracted.m_41613_();
            extractedAcc.m_41769_(extracted.m_41613_());
            if (simulate) continue;
            applicableSlots.add(slot);
        }
        if (!simulate) {
            IntListIterator it = applicableSlots.iterator();
            extractedAcc = ItemStack.f_41583_;
            while (it.hasNext() && amount > 0) {
                ItemStack extracted;
                int slot = it.nextInt();
                ItemStack extractedSimulated = this.itemHandler.extractItem(slot, amount, true);
                if (extractedSimulated.m_41619_()) continue;
                if (extractedAcc.m_41619_()) {
                    extracted = this.itemHandler.extractItem(slot, amount, false);
                    extractedAcc = extracted.m_41777_();
                    amount -= extracted.m_41613_();
                    continue;
                }
                if (!ItemMatch.areItemStacksEqual(extractedSimulated, extractedAcc, 5)) continue;
                extracted = this.itemHandler.extractItem(slot, amount, false);
                amount -= extracted.m_41613_();
                extractedAcc.m_41769_(extracted.m_41613_());
            }
        }
        return extractedAcc;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, boolean simulate) {
        PrimitiveIterator.OfInt itSimulated = this.getNonEmptySlotsWithItemStack(matchStack, matchFlags);
        IntArrayList applicableSlots = simulate ? null : new IntArrayList();
        int amount = matchStack.m_41613_();
        ItemStack extractedAcc = ItemStack.f_41583_;
        while (itSimulated.hasNext() && amount > 0) {
            int slot = itSimulated.nextInt();
            ItemStack extracted = this.itemHandler.extractItem(slot, amount, true);
            if (extracted.m_41619_()) continue;
            if (extractedAcc.m_41619_()) {
                extractedAcc = extracted.m_41777_();
                amount -= extracted.m_41613_();
                if (simulate) continue;
                applicableSlots.add(slot);
                continue;
            }
            if (!ItemMatch.areItemStacksEqual(extracted, extractedAcc, matchFlags & 0xFFFFFFF7)) continue;
            amount -= extracted.m_41613_();
            extractedAcc.m_41769_(extracted.m_41613_());
            if (simulate) continue;
            applicableSlots.add(slot);
        }
        if (!simulate) {
            IntListIterator it = applicableSlots.iterator();
            amount = matchStack.m_41613_();
            extractedAcc = ItemStack.f_41583_;
            while (it.hasNext() && amount > 0) {
                ItemStack extracted;
                int slot = it.nextInt();
                ItemStack extractedSimulated = this.itemHandler.extractItem(slot, amount, true);
                if (extractedSimulated.m_41619_()) continue;
                if (extractedAcc.m_41619_()) {
                    extracted = this.itemHandler.extractItem(slot, amount, false);
                    extractedAcc = extracted.m_41777_();
                    amount -= extracted.m_41613_();
                    continue;
                }
                if (!ItemMatch.areItemStacksEqual(extractedSimulated, extractedAcc, matchFlags & 0xFFFFFFF7)) continue;
                extracted = this.itemHandler.extractItem(slot, amount, false);
                amount -= extracted.m_41613_();
                extractedAcc.m_41769_(extracted.m_41613_());
            }
        }
        return extractedAcc;
    }

    @Override
    public int getLimit() {
        int total = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            total += this.itemHandler.getSlotLimit(i);
        }
        return total;
    }
}

