/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianWither;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;

public class GroundEffectPhase
extends ChargeUpPhase {
    private List<Mob> summoned = new ArrayList<Mob>();
    private int initialWithers = 0;
    private int spawnCount = 0;
    private int nextWither = 0;
    private int withersKilled = 0;
    private int attackStage = 0;
    private int actionDuration = 0;
    private int actionTime = 0;

    public GroundEffectPhase(DraconicGuardianEntity guardian) {
        super(guardian, 100);
        this.disableFlight = true;
        this.trapPlayers = true;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.summoned == null) {
            this.guardian.m_9236_().m_142425_((EntityTypeTest)DEContent.ENTITY_GUARDIAN_WITHER.get(), this.guardian.m_20191_().m_82400_(500.0), e -> true).forEach(Entity::m_146870_);
            this.summoned = new ArrayList<Mob>();
        }
        if (!this.isCharged()) {
            return;
        }
        this.updateWithers();
        if (this.attackStage == 0 && this.withersKilled < this.initialWithers && this.chargedTime < 3600) {
            return;
        }
        if (this.actionTime >= this.actionDuration) {
            this.chargeTime = 0;
            this.sendPacket(null, 0);
            this.actionDuration = 120 + this.random.m_188503_(120);
            this.actionTime = 0;
            ++this.attackStage;
            return;
        }
        ++this.actionTime;
        switch (this.attackStage) {
            case 0: {
                ++this.attackStage;
            }
            case 1: {
                this.updateSpinFire();
                break;
            }
            case 2: {
                this.updateSpinFire();
                break;
            }
            case 3: {
                this.updateRandomFire();
                if (this.actionTime < this.actionDuration) break;
                this.guardian.getPhaseManager().setPhase(PhaseType.START);
                this.guardian.m_9236_().m_142425_((EntityTypeTest)DEContent.ENTITY_GUARDIAN_WITHER.get(), this.guardian.m_20191_().m_82400_(500.0), e -> true).forEach(Entity::m_146870_);
            }
        }
    }

    @Override
    public void initPhase() {
        super.initPhase();
        this.initialWithers = 8 + this.random.m_188503_(6);
        this.summoned = null;
        this.withersKilled = 0;
        this.spawnCount = 0;
        this.actionDuration = 0;
        this.attackStage = 0;
    }

    private void updateWithers() {
        this.withersKilled = (int)((long)this.withersKilled + this.summoned.stream().filter(e -> !e.m_6084_()).count());
        this.summoned.removeIf(e -> !e.m_6084_());
        if (this.nextWither > 0) {
            --this.nextWither;
            if (this.nextWither == 0) {
                this.summonWither(this.spawnCount < this.initialWithers);
            }
        } else if (this.spawnCount < this.initialWithers && this.chargedTime % 5 == 0) {
            this.nextWither = 3 + this.random.m_188503_(5);
            ++this.spawnCount;
        } else if (this.spawnCount >= this.initialWithers && this.withersKilled >= this.initialWithers && this.summoned.size() < 2) {
            this.nextWither = 80 + this.random.m_188503_(140);
        }
        for (Mob wither : this.summoned) {
            Player closeTarget = this.guardian.m_9236_().m_45924_(wither.m_20185_(), wither.m_20186_(), wither.m_20189_(), 200.0, true);
            if (closeTarget == null) continue;
            wither.m_6710_((LivingEntity)closeTarget);
        }
    }

    private void summonWither(boolean canLoot) {
        GuardianWither wither = (GuardianWither)((EntityType)DEContent.ENTITY_GUARDIAN_WITHER.get()).m_20615_(this.guardian.m_9236_());
        Vector3 spawnPos = null;
        for (int i = 0; i < 10 && !(MathUtils.distanceSq((Vector3)(spawnPos = Vector3.fromEntity((Entity)this.guardian).add((double)(this.random.m_188503_(80) - 40), (double)(this.random.m_188503_(20) - 10), (double)(this.random.m_188503_(80) - 40))), (Vector3)Vector3.fromEntity((Entity)this.guardian)) < 1600.0); ++i) {
        }
        wither.m_6034_(spawnPos.x, spawnPos.y - 10.0, spawnPos.z);
        wither.m_6593_((Component)Component.m_237115_((String)"entity.draconicevolution.guardian_wither"));
        wither.m_31510_(3);
        this.guardian.m_9236_().m_7967_((Entity)wither);
        this.summoned.add((Mob)wither);
        wither.f_31429_ = 10000;
    }

    private void updateSpinFire() {
        Vector3 headPos = Vector3.fromEntity((Entity)this.guardian);
        float rotation = (this.guardian.f_19859_ - 90.0f - 55.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(Mth.m_14089_((float)rotation) * 7.0f), 0.0, (double)(Mth.m_14031_((float)rotation) * 7.0f));
        boolean perimeterHit = this.attackStage == 1;
        rotation = (float)((double)rotation + 1.5707963267948966);
        BlockPos origin = this.guardian.getArenaOrigin();
        int range = perimeterHit ? 30 + this.random.m_188503_(40) : this.random.m_188503_(60);
        double targetX = this.guardian.m_20185_() + (double)(Mth.m_14089_((float)rotation) * (float)range);
        double targetY = origin == null ? this.guardian.m_20186_() - 30.0 : (double)(origin.m_123342_() + 15);
        double targetZ = this.guardian.m_20189_() + (double)(Mth.m_14031_((float)rotation) * (float)range);
        Vector3 aim = new Vector3(targetX, targetY, targetZ).subtract(headPos).normalize();
        GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.m_9236_(), (LivingEntity)this.guardian, aim.x, aim.y, aim.z, null, 25.0, 15.0);
        projectile.m_7678_(headPos.x, headPos.y, headPos.z, 0.0f, 0.0f);
        this.guardian.m_9236_().m_7967_((Entity)projectile);
        BCoreNetwork.sendSound((Level)this.guardian.m_9236_(), (Entity)this.guardian, (SoundEvent)SoundEvents.f_11896_, (SoundSource)SoundSource.HOSTILE, (float)32.0f, (float)((this.random.m_188501_() - this.random.m_188501_()) * 0.2f + 1.0f), (boolean)false);
        BCoreNetwork.sendParticle((Level)this.guardian.m_9236_(), (ParticleOptions)ParticleTypes.f_123813_, (Vector3)headPos, (Vector3)Vector3.ZERO, (boolean)true);
        this.guardian.m_146922_(this.guardian.m_146908_() + (1.0f + (float)this.actionTime / (float)this.actionDuration * 10.0f));
    }

    private void updateRandomFire() {
        Vector3 headPos = Vector3.fromEntity((Entity)this.guardian);
        float rotation = (this.guardian.f_19859_ - 90.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(Mth.m_14089_((float)rotation) * 7.0f), 0.0, (double)(Mth.m_14031_((float)rotation) * 7.0f));
        for (int i = 0; i < 2; ++i) {
            Vector3 target = Vector3.fromEntity((Entity)this.guardian).add((double)(this.random.m_188503_(160) - 80), -30.0, (double)(this.random.m_188503_(160) - 80));
            BlockPos origin = this.guardian.getArenaOrigin();
            if (origin != null) {
                target.y = origin.m_123342_() + 15;
            }
            Vector3 aim = target.subtract(headPos).normalize().multiply(3.0);
            GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.m_9236_(), (LivingEntity)this.guardian, aim.x, aim.y, aim.z, null, 25.0, 15.0);
            projectile.m_7678_(headPos.x, headPos.y, headPos.z, 0.0f, 0.0f);
            this.guardian.m_9236_().m_7967_((Entity)projectile);
        }
        BCoreNetwork.sendParticle((Level)this.guardian.m_9236_(), (ParticleOptions)ParticleTypes.f_123813_, (Vector3)headPos, (Vector3)Vector3.ZERO, (boolean)true);
        BCoreNetwork.sendSound((Level)this.guardian.m_9236_(), (Entity)this.guardian, (SoundEvent)SoundEvents.f_11896_, (SoundSource)SoundSource.HOSTILE, (float)32.0f, (float)((this.random.m_188501_() - this.random.m_188501_()) * 0.2f + 1.0f), (boolean)false);
        this.guardian.m_146922_(this.guardian.m_146908_() + 1.0f);
    }

    public PhaseType<GroundEffectPhase> getType() {
        return PhaseType.GROUND_EFFECTS;
    }

    protected final Vec3 calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

