/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.vec.Matrix4;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderModularShovel
extends ToolRenderBase {
    private final ToolRenderBase.ToolPart basePart;
    private final ToolRenderBase.ToolPart materialPart;
    private final ToolRenderBase.ToolPart gemPart;
    private final ToolRenderBase.ToolPart tracePart;

    public RenderModularShovel(TechLevel techLevel) {
        super(techLevel, "shovel");
        Map model = new OBJParser(new ResourceLocation("draconicevolution", "models/item/equipment/shovel.obj")).ignoreMtl().parse();
        this.basePart = this.basePart(CCModel.combine(Arrays.asList((CCModel)model.get("handle"), (CCModel)model.get("gem_holder"))).backfacedCopy());
        this.materialPart = this.materialPart(((CCModel)model.get("blade")).twoFacedCopy());
        this.gemPart = this.gemPart(((CCModel)model.get("gem")).backfacedCopy());
        this.tracePart = this.tracePart(((CCModel)model.get("trace")).backfacedCopy());
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemDisplayContext context, Matrix4 mat, MultiBufferSource buffers, boolean gui) {
        this.transform(mat, 0.27, 0.27, 0.5, gui ? 1.125 : 1.15);
        this.basePart.render(context, buffers, mat);
        this.materialPart.render(context, buffers, mat);
        this.tracePart.render(context, buffers, mat);
        this.gemPart.render(context, buffers, mat);
    }
}

