/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities.logic;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.modules.entities.logic.IHarvestHandler;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ForestHarvestHandler
implements IHarvestHandler {
    private final int speed;
    private final int range;
    private final boolean harvestLeaves;
    private BlockPos origin;
    private PriorityQueue<Pos> sortedHarvestQue = new PriorityQueue();
    private LinkedList<Long> searchQue = new LinkedList();
    private Set<Long> processedBlocks = new HashSet<Long>();
    private Set<Long> searchedXZPositions = new HashSet<Long>();
    private boolean complete = false;
    private BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();

    public ForestHarvestHandler(int speed, int range, boolean leaves) {
        this.speed = speed;
        this.range = range;
        this.harvestLeaves = leaves;
    }

    @Override
    public boolean start(BlockPos origin, Level level, ServerPlayer player) {
        BlockState state = level.m_8055_(origin);
        if (!this.canSearchUnder(state)) {
            return false;
        }
        int i = 0;
        do {
            if (i++ > 80) {
                return false;
            }
            if ((origin = origin.m_7495_()).m_123342_() >= level.m_141937_()) continue;
            return false;
        } while (!this.canSearchThrough(state = level.m_8055_(origin)) || this.isHarvestable(state));
        if (!this.canSearchUnder(level.m_8055_(origin.m_7494_()))) {
            return false;
        }
        this.searchQue.add(origin.m_121878_());
        this.origin = origin.m_7949_();
        return true;
    }

    @Override
    public void tick(Level level, ServerPlayer player, ItemStack stack, IOPStorage storage, InventoryDynamic stackCollector) {
        int i;
        if (this.origin == null || this.complete || level.f_46443_) {
            return;
        }
        if (!this.sortedHarvestQue.isEmpty()) {
            for (i = 0; i < this.speed && !this.sortedHarvestQue.isEmpty(); ++i) {
                this.updateHarvest(level, (Player)player, stack, storage, stackCollector);
            }
        }
        if (!this.searchQue.isEmpty()) {
            for (i = 0; i < this.speed * 4 && !this.searchQue.isEmpty(); ++i) {
                this.updateSearch(level, (Player)player);
            }
        }
        if (!this.sortedHarvestQue.isEmpty() || !this.searchQue.isEmpty()) {
            return;
        }
        this.complete = true;
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * ((player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.7f + 1.8f));
    }

    private void updateSearch(Level level, Player player) {
        this.mPos.m_122188_(this.searchQue.removeFirst().longValue());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((double)level.f_46441_.m_188501_() < 0.1) {
                serverLevel.m_8624_((ServerPlayer)player, (ParticleOptions)ParticleTypes.f_123796_, true, (double)this.mPos.m_123341_() + 0.5, (double)this.mPos.m_123342_() + 1.5, (double)this.mPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
        Utils.hollowCube((BlockPos)this.mPos.m_7918_(-1, -1, -1), (BlockPos)this.mPos.m_7918_(1, 1, 1), pos -> {
            long longXZPos = BlockPos.m_121882_((int)pos.m_123341_(), (int)0, (int)pos.m_123343_());
            if (this.searchedXZPositions.contains(longXZPos)) {
                return;
            }
            long longPos = pos.m_121878_();
            if (this.origin.m_123331_((Vec3i)pos) > (double)(this.range * this.range)) {
                this.searchedXZPositions.add(longXZPos);
                this.processedBlocks.add(longPos);
                return;
            }
            BlockState state = level.m_8055_(pos);
            if (this.isHarvestable(state)) {
                this.searchedXZPositions.add(longXZPos);
                this.queHarvest(level, (BlockPos)pos);
                return;
            }
            BlockState aboveState = level.m_8055_(pos.m_7494_());
            if (this.canSearchThrough(state) && this.canSearchUnder(aboveState)) {
                this.searchedXZPositions.add(longXZPos);
                this.searchQue.add(pos.m_121878_());
                if (this.isHarvestable(aboveState)) {
                    this.queHarvest(level, pos.m_7494_());
                }
            }
            this.processedBlocks.add(longPos);
        });
    }

    private void updateHarvest(Level level, Player player, ItemStack stack, IOPStorage storage, InventoryDynamic stackCollector) {
        Pos next = this.sortedHarvestQue.poll();
        if (next == null) {
            return;
        }
        this.mPos.m_122188_(next.pos);
        this.doHarvest(stack, player, level, this.mPos.m_7949_(), storage, stackCollector);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((double)level.f_46441_.m_188501_() < 0.1) {
                serverLevel.m_8624_((ServerPlayer)player, (ParticleOptions)ParticleTypes.f_123744_, true, (double)this.mPos.m_123341_() + 0.5, (double)this.mPos.m_123342_() + 0.5, (double)this.mPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
        Utils.hollowCube((BlockPos)this.mPos.m_7918_(-1, -1, -1), (BlockPos)this.mPos.m_7918_(1, 1, 1), pos -> {
            long longPos = pos.m_121878_();
            if (this.processedBlocks.contains(longPos)) {
                return;
            }
            this.processedBlocks.add(longPos);
            if (this.origin.m_123331_((Vec3i)pos) > (double)(this.range * this.range)) {
                return;
            }
            BlockState state = level.m_8055_(pos);
            if (this.isHarvestable(state)) {
                this.queHarvest(level, (BlockPos)pos);
            }
        });
    }

    private void queHarvest(Level level, BlockPos pos) {
        this.sortedHarvestQue.add(new Pos(pos.m_121878_(), (int)Utils.getDistanceSq((double)pos.m_123341_(), (double)pos.m_123343_(), (double)this.origin.m_123341_(), (double)this.origin.m_123343_()) + level.f_46441_.m_188503_(16)));
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void stop(Level level, ServerPlayer player) {
    }

    private boolean canSearchThrough(BlockState state) {
        return !state.m_60795_() && !state.m_204336_(BlockTags.f_278394_) && !state.m_204336_(BlockTags.f_13041_) && !state.m_204336_(BlockTags.f_13106_) && !state.m_204336_(BlockTags.f_13035_) && state.m_60819_().m_76178_();
    }

    private boolean canSearchUnder(BlockState state) {
        return (state.m_60795_() || state.m_204336_(BlockTags.f_278394_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_)) && state.m_60819_().m_76178_();
    }

    private boolean isHarvestable(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || this.harvestLeaves && state.m_204336_(BlockTags.f_13035_);
    }

    private record Pos(long pos, int distance) implements Comparable<Pos>
    {
        @Override
        public int compareTo(@NotNull Pos o) {
            return Integer.compare(this.distance, o.distance);
        }
    }
}

