/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.init.EquipCfg;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class NightVisionEntity
extends ModuleEntity<AutoFeedData> {
    private BooleanProperty enabled = new BooleanProperty("night_vision.enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
    private IntegerProperty enableInLight;
    private boolean wasJustDisabled = false;
    private boolean appliedByModule = false;
    private int tick;
    private int disableTimer = 0;

    public NightVisionEntity(Module<AutoFeedData> module) {
        super(module);
        this.addProperty(this.enabled);
        this.enableInLight = new IntegerProperty("night_vision.light_level", 15).min(0).max(15).setFormatter(ConfigProperty.IntegerFormatter.RAW);
        this.addProperty(this.enableInLight);
        this.enabled.setChangeListener(() -> {
            this.wasJustDisabled = !this.enabled.getValue();
        });
        this.savePropertiesToItem = true;
    }

    @Override
    public void tick(ModuleContext context) {
        boolean shouldApply;
        ServerPlayer player;
        if (this.tick++ % 20 != 0 || !(context instanceof StackModuleContext)) {
            return;
        }
        StackModuleContext ctx = (StackModuleContext)context;
        LivingEntity livingEntity = ctx.getEntity();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).m_9236_().m_5776_() || !ctx.isEquipped()) {
            return;
        }
        if (!this.enabled.getValue()) {
            if (this.wasJustDisabled && this.appliedByModule) {
                player.m_21195_(MobEffects.f_19611_);
                this.appliedByModule = false;
                this.wasJustDisabled = false;
            }
            return;
        }
        IOPStorage opStorage = ctx.getOpStorage();
        if (opStorage == null || opStorage.getOPStored() < (long)EquipCfg.nightVisionEnergy * 20L) {
            if (this.appliedByModule && this.disableTimer++ >= 3) {
                player.m_21195_(MobEffects.f_19611_);
                this.appliedByModule = false;
            }
            return;
        }
        boolean bl = shouldApply = player.m_9236_().m_45524_(player.m_20183_(), 0) <= this.enableInLight.getValue();
        if (shouldApply) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 302, 0, false, false));
            ctx.getOpStorage().modifyEnergyStored((long)(-EquipCfg.nightVisionEnergy) * 20L);
            this.appliedByModule = true;
            this.disableTimer = 0;
        } else if (this.appliedByModule && this.disableTimer++ >= 3) {
            player.m_21195_(MobEffects.f_19611_);
            this.appliedByModule = true;
        }
    }
}

