/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.twigs.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PaperLanternBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_STANDING = Shapes.m_83110_((VoxelShape)PaperLanternBlock.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape)PaperLanternBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0));
    public static final VoxelShape SHAPE_HANGING = Shapes.m_83124_((VoxelShape)PaperLanternBlock.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape[])new VoxelShape[]{PaperLanternBlock.m_49796_((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), PaperLanternBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0)});
    private final Block content;

    public PaperLanternBlock(Block content, BlockBehaviour.Properties settings) {
        super(settings);
        this.content = content;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Direction getHangingDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public Component createContentTooltip() {
        return this.content.m_49954_().m_130940_(ChatFormatting.GRAY);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HANGING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? SHAPE_HANGING : SHAPE_STANDING;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        FluidState fluidState = world.m_6425_(pos);
        for (Direction direction : ctx.m_6232_()) {
            BlockState state;
            if (direction.m_122434_() != Direction.Axis.Y || !(state = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)world, pos)) continue;
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return this.getHangingDirection(blockState).m_122424_() == direction && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = this.getHangingDirection(state).m_122424_();
        return Block.m_49863_((LevelReader)world, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        if (this.content != Blocks.f_50016_) {
            list.add(this.createContentTooltip());
        }
    }
}

