/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.core.research.GlobalResearchEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ResearchEffectManager
implements IResearchEffectManager {
    private final Map<ResourceLocation, IResearchEffect<?>> effectMap = new HashMap();

    @Override
    public <W extends IResearchEffect<?>> W getEffect(ResourceLocation id, @NotNull Class<W> type) {
        IResearchEffect<?> effect = this.effectMap.get(id);
        if (type.isInstance(effect)) {
            return (W)effect;
        }
        return null;
    }

    @Override
    public double getEffectStrength(ResourceLocation id) {
        if (this.effectMap.containsKey(id) && this.effectMap.get(id) instanceof GlobalResearchEffect) {
            return ((GlobalResearchEffect)this.effectMap.get(id)).getEffect();
        }
        return 0.0;
    }

    @Override
    public void applyEffect(IResearchEffect<?> effect) {
        if (this.effectMap.containsKey(effect.getId())) {
            IResearchEffect<?> effectInMap = this.effectMap.get(effect.getId());
            if (effect.overrides(effectInMap)) {
                this.effectMap.put(effect.getId(), effect);
            }
        } else {
            this.effectMap.put(effect.getId(), effect);
        }
    }

    @Override
    public void removeAllEffects() {
        this.effectMap.clear();
    }
}

