/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.recipes;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingCraftingType
extends CraftingType {
    public BrewingCraftingType() {
        super(ModCraftingTypes.BREWING_ID);
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        ICompatibilityManager compatibilityManager = MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager();
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            List inputs = compatibilityManager.getListOfAllItems().stream().filter(arg_0 -> ((IBrewingRecipe)recipe).isInput(arg_0)).collect(Collectors.toList());
            List ingredients = compatibilityManager.getListOfAllItems().stream().filter(arg_0 -> ((IBrewingRecipe)recipe).isIngredient(arg_0)).collect(Collectors.toList());
            for (ItemStack input : inputs) {
                for (ItemStack ingredient : ingredients) {
                    ItemStack output = recipe.getOutput(input, ingredient);
                    if (output.m_41619_()) continue;
                    ItemStack actualInput = input.m_41777_();
                    actualInput.m_41764_(3);
                    ItemStack actualOutput = output.m_41777_();
                    actualOutput.m_41764_(3);
                    recipes.add(new GenericRecipe(null, actualOutput, Collections.emptyList(), Arrays.asList(Collections.singletonList(ingredient), Collections.singletonList(actualInput)), 1, Blocks.f_50255_, null, (EquipmentTypeEntry)ModEquipmentTypes.none.get(), Collections.emptyList(), -1));
                }
            }
        }
        return recipes;
    }
}

