/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.core.colony.fields.FarmField;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class FarmFieldPlotResizeMessage
extends AbstractColonyServerMessage {
    private int size;
    private Direction direction;
    private BlockPos position;

    public FarmFieldPlotResizeMessage() {
    }

    public FarmFieldPlotResizeMessage(IColony colony, int size, Direction direction, BlockPos position) {
        super(colony);
        this.size = size;
        this.direction = direction;
        this.position = position;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (!isLogicalServer || ctxIn.getSender() == null) {
            return;
        }
        colony.getBuildingManager().getField(f -> f.getFieldType().equals(FieldRegistries.farmField.get()) && f.getPosition().equals((Object)this.position)).map(m -> (FarmField)m).ifPresent(field -> field.setRadius(this.direction, this.size));
    }

    @Override
    public void toBytesOverride(FriendlyByteBuf buf) {
        buf.writeInt(this.size);
        buf.writeInt(this.direction.m_122416_());
        buf.m_130064_(this.position);
    }

    @Override
    public void fromBytesOverride(FriendlyByteBuf buf) {
        this.size = buf.readInt();
        this.direction = Direction.m_122407_((int)buf.readInt());
        this.position = buf.m_130135_();
    }
}

