/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.core.colony.buildings.modules.FieldsModule;
import com.minecolonies.core.colony.fields.registry.FieldDataManager;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFieldMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int moduleID = 0;
    private FriendlyByteBuf fieldData;
    private boolean assign;

    public AssignFieldMessage() {
    }

    public AssignFieldMessage(IBuildingView building, IField field, boolean assign, int moduleID) {
        super(building);
        this.assign = assign;
        this.fieldData = FieldDataManager.fieldToBuffer(field);
        this.moduleID = moduleID;
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.fieldData.resetReaderIndex();
        buf.writeBoolean(this.assign);
        buf.writeInt(this.moduleID);
        buf.writeBytes((ByteBuf)this.fieldData);
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.moduleID = buf.readInt();
        this.fieldData = new FriendlyByteBuf(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.fieldData, buf.readableBytes());
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IField parsedField = FieldDataManager.bufferToField(this.fieldData);
        colony.getBuildingManager().getField(otherField -> otherField.equals(parsedField)).ifPresent(field -> {
            IBuildingModule patt2649$temp = building.getModule(this.moduleID);
            if (patt2649$temp instanceof FieldsModule) {
                FieldsModule fieldsModule = (FieldsModule)patt2649$temp;
                if (this.assign) {
                    fieldsModule.assignField((IField)field);
                } else {
                    fieldsModule.freeField((IField)field);
                }
            }
        });
    }
}

