/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.network.messages.client.OpenCantFoundColonyWarningMessage;
import com.minecolonies.core.network.messages.client.OpenColonyFoundingCovenantMessage;
import com.minecolonies.core.network.messages.client.OpenDeleteAbandonColonyMessage;
import com.minecolonies.core.network.messages.client.OpenReactivateColonyMessage;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class GetColonyInfoMessage
implements IMessage {
    BlockPos pos;

    public GetColonyInfoMessage() {
    }

    public GetColonyInfoMessage(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer sender = ctxIn.getSender();
        Level world = ctxIn.getSender().f_19853_;
        if (sender == null) {
            return;
        }
        if (IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos) instanceof Colony) {
            MessageUtils.format("com.minecolonies.coremod.gui.nobuilding", new Object[0]).sendTo(new Player[]{sender});
            return;
        }
        IColony iColony = IColonyManager.getInstance().getIColonyByOwner(world, (Player)sender);
        if (iColony instanceof Colony) {
            Colony colony = (Colony)iColony;
            Network.getNetwork().sendToPlayer(new OpenDeleteAbandonColonyMessage(this.pos, colony.getName(), colony.getCenter(), colony.getID()), sender);
            return;
        }
        IColony nextColony = IColonyManager.getInstance().getClosestColony(world, this.pos);
        if (IColonyManager.getInstance().isFarEnoughFromColonies(world, this.pos)) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(this.pos, world.m_220360_()));
            if (spawnDistance < (double)((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue()) {
                Network.getNetwork().sendToPlayer(new OpenCantFoundColonyWarningMessage((Component)Component.m_237110_((String)"com.minecolonies.core.founding.tooclosetospawn", (Object[])new Object[]{(int)((double)((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue() - spawnDistance)}), this.pos, true), sender);
            } else if (spawnDistance > (double)((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).intValue()) {
                Network.getNetwork().sendToPlayer(new OpenCantFoundColonyWarningMessage((Component)Component.m_237110_((String)"com.minecolonies.core.founding.toofarfromspawn", (Object[])new Object[]{(int)(spawnDistance - (double)((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).intValue())}), this.pos, true), sender);
            } else {
                TileEntityColonyBuilding townhall;
                BlockEntity blockEntity = world.m_7702_(this.pos);
                if (blockEntity instanceof TileEntityColonyBuilding && (townhall = (TileEntityColonyBuilding)blockEntity).getPositionedTags().containsKey(BlockPos.f_121853_) && townhall.getPositionedTags().get(BlockPos.f_121853_).contains("deactivated")) {
                    Network.getNetwork().sendToPlayer(new OpenReactivateColonyMessage(nextColony == null ? "" : nextColony.getName(), nextColony == null ? Integer.MAX_VALUE : (int)BlockPosUtil.getDistance(nextColony.getCenter(), this.pos) - ((Integer)MineColonies.getConfig().getServer().initialColonySize.get() << 4), this.pos), sender);
                } else {
                    Network.getNetwork().sendToPlayer(new OpenColonyFoundingCovenantMessage(nextColony == null ? "" : nextColony.getName(), nextColony == null ? Integer.MAX_VALUE : (int)BlockPosUtil.getDistance(nextColony.getCenter(), this.pos) - ((Integer)MineColonies.getConfig().getServer().initialColonySize.get() << 4), this.pos), sender);
                }
            }
        } else {
            if (nextColony == null) {
                return;
            }
            int blockRange = Math.max((Integer)MineColonies.getConfig().getServer().minColonyDistance.get(), (Integer)MineColonies.getConfig().getServer().initialColonySize.get()) << 4;
            int distance = (int)BlockPosUtil.getDistance(this.pos, nextColony.getCenter());
            Network.getNetwork().sendToPlayer(new OpenCantFoundColonyWarningMessage((Component)Component.m_237110_((String)"com.minecolonies.core.founding.tooclosetocolony", (Object[])new Object[]{Math.max(100, blockRange - distance)}), this.pos, false), sender);
        }
    }
}

